import Swiper from 'swiper';

const compare = () => {
    function initSwiper() {
        new Swiper('.compare-swiper', {
            slidesPerView: 3,
            spaceBetween: 25,
            navigation: {
                nextEl: '.custom-compare-next',
                prevEl: '.custom-compare-prev',
            },
            keyboard: {
                enabled: true,
            },
            breakpoints: {
                992: {
                    slidesPerView: 1,
                },
                1550: {
                    slidesPerView: 2,
                },
            }
        });
    }
    function postCompareInfo(compareCourses) {
        $.ajax({
            type: 'POST',
            url: ajaxObject.ajax_url,
            data: {
                action: 'compare_courses',
                courses: compareCourses,
            },
            success(data) {
                $('.compare-content').html(data);
            }
        });
    }
    function removeCompareInfo(compareCourses) {
        $.ajax({
            type: 'POST',
            url: ajaxObject.ajax_url,
            data: {
                action: 'compare_courses',
                courses: compareCourses,
            },
            success(data) {
                $('.compare-content').html(data);
                $('.trigger-compare').find('.text-section')
                    .text('Close');
                initSwiper();
                if (!data) {
                    $('.course-compare-area').removeClass('active-compare');
                    $('.site-footer').removeClass('active-compare-footer');
                }
            }
        });
    }
    $(document).ready(function() {
        /* global ajaxObject */
        const compareData = $('.course-compare-area').attr('data-compare-courses');
        const courses = compareData ? $.parseJSON(compareData) : [];

        $('body').on('click', '.add-to-compare', function(e) {
            e.preventDefault();
            const courseId = $(this).data('course-id');
            $(`#mobile-compare-item-${courseId}, #compare-item-${courseId}`).toggleClass('compare-is-active');
            $('.site-footer').toggleClass('active-compare-footer');
            const compareSelector = $(`#compare-item-${courseId}, .mobile-overlay-block #compare-item-${courseId}`);

            if ($(this).hasClass('compare-is-active')) {
                compareSelector.find('.custom-compare-svg')
                    .attr('data-prefix', 'fas');
                $(`#mobile-compare-item-${courseId}`).text('Remove from compare');
                courses.push(courseId); // add course id to array
            } else {
                compareSelector.find('.custom-compare-svg')
                    .attr('data-prefix', 'far');
                $(`#mobile-compare-item-${courseId}`).text('Compare Course');
                courses.splice($.inArray(courseId, courses), 1); // remove course id from array
            }

            const compareCourses = JSON.stringify(courses);
            postCompareInfo(compareCourses);
        });

        $('body').on('click', '.remove-from-compare', function(e) {
            e.preventDefault();
            const courseId = $(this).data('course-id');
            courses.splice($.inArray(courseId, courses), 1);
            const compareCourses = JSON.stringify(courses);
            $(`#compare-item-${courseId}`).find('.custom-compare-svg')
                .attr('data-prefix', 'far');
            $(`#mobile-compare-item-${courseId}`).text('Compare course');
            removeCompareInfo(compareCourses);
        });
    });

    $('body').on('click', '.trigger-compare', function() {
        $('.course-compare-area').toggleClass('active-compare');
        if ($('.course-compare-area').hasClass('active-compare') === true) {
            $(this).find('.text-section')
                .text('Close');
            $('.course-block').focus();
        } else {
            $(this).find('.text-section')
                .text('Compare');
        }
        initSwiper();
    });
};

export default compare;
