<?= get_template_part('templates/sections/compare-bar');
$activeCompare = isset($_SESSION['courses']) && $_SESSION['courses'] !== '[]' ? 'active-compare-footer' : '';
?>
<footer class="site-footer <?= $activeCompare; ?>" role="contentinfo">
    <div class="container">
        <div class="row primary-row">
            <div class="col-lg-12 col-xxl-2 logo-col">
                <img src="<?php the_field('footer_logo', 'option') ?>" alt="NESCol Logo">
            </div>
            <div class="col-sm-6 col-md-4 col-lg-3 col-xxl-2">
                <?php
                $footerMenu1 = get_field('footer_menu_selection_1', 'option');
                $footerMenuTitle1 = get_field('footer_menu_title_1', 'option');
                if (has_nav_menu($footerMenu1)) { ?>
                    <h3><?= $footerMenuTitle1; ?></h3>
                    <?php wp_nav_menu(['theme_location' => $footerMenu1]);
                }
                ?>
            </div>
            <div class="col-sm-6 col-md-4 col-lg-3 col-xxl-2">
                <?php
                $footerMenu2 = get_field('footer_menu_selection_2', 'option');
                $footerMenuTitle2 = get_field('footer_menu_title_2', 'option');
                if (has_nav_menu($footerMenu2)) { ?>
                    <h3><?= $footerMenuTitle2; ?></h3>
                    <?php wp_nav_menu(['theme_location' => $footerMenu2]);
                }
                ?>
            </div>
            <div class="col-sm-6 col-md-4 col-lg-3 col-xxl-2">
                <?php
                $footerMenu3 = get_field('footer_menu_selection_3', 'option');
                $footerMenuTitle3 = get_field('footer_menu_title_3', 'option');
                if (has_nav_menu($footerMenu3)) { ?>
                    <h3><?= $footerMenuTitle3; ?></h3>
                    <?php wp_nav_menu(['theme_location' => $footerMenu3]);
                }
                ?>
            </div>
            <div class="col-sm-6 col-md-4 col-lg-3 col-xxl-2">
                <?php
                $footerMenu4 = get_field('footer_menu_selection_4', 'option');
                $footerMenuTitle4 = get_field('footer_menu_title_4', 'option');
                if (has_nav_menu($footerMenu4)) { ?>
                    <h3><?= $footerMenuTitle4; ?></h3>
                    <?php wp_nav_menu(['theme_location' => $footerMenu4]);
                }
                ?>
            </div>
            <div class="col-sm-6 col-md-4 col-lg-12 col-xxl-2 contact-col">
                <?php
                $phone = get_field('contact_phone_number', 'option');
                $email = get_field('contact_email_address', 'option');
                if($phone || $email) {
                    $footerMenuTitle5 = get_field('footer_menu_title_5', 'option'); ?>
                    <h3><?= $footerMenuTitle5; ?></h3>
                    <ul role="list">
                        <li role="listitem"><a href="tel:<?= str_replace(' ', '', $phone); ?>">T: <?= $phone; ?></a></li>
                        <li role="listitem"><a href="mailto:<?= $email; ?>">E: <?= $email; ?></a></li>
                    </ul>
                <?php } ?>
                <?php $complaintsLink = get_field('complaints_link', 'option');
                if($complaintsLink) { ?>
                    <div class="complaints-link">
                        <a href="<?= $complaintsLink['url']; ?>"><?= $complaintsLink['title']; ?></a>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="row secondary-row">
            <div class="col-lg-6">
                <?php if( have_rows('social_media_channels', 'option') ) { ?>
                    <h3 class="social">Follow NESCol</h3>
                    <ul class="socials">
                        <?php while ( have_rows('social_media_channels', 'option') ) {  the_row(); ?>
                            <li>
                                <a href="<?php the_sub_field('full_url'); ?>" target="_blank" aria-label="NESCol's <?php the_sub_field('social_title') ?> page">
                                    <span class="fa-stack">
                                      <i class="fas fa-circle fa-stack-2x" aria-hidden="true"></i>
                                      <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon" aria-hidden="true" title="<?php the_sub_field('social_title'); ?>"></i>
                                    </span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <div class="accessibility-toggles col-lg-12 col-xl-6 justify-content-xl-end">
                <div class="switch-item d-flex align-items-center" id="accessibility--high-contrast">
                    <div class="high-contrast label">High contrast option:</div>
                    <label class="switch">
                        <input type="checkbox" id="contrast" class="checkbox">
                        <span class="slider round"></span>
                        <div class="switch-state">Off</div>
                    </label>
                </div>
                <div class="switch-item d-flex align-items-center" id="accessibility--reduced-motion">
                    <div class="remove-animation label">Remove animations:</div>
                    <label class="switch">
                        <input type="checkbox" id="animations" class="checkbox">
                        <span class="slider round"></span>
                        <div class="switch-state">Off</div>
                    </label>
                </div>
            </div>
        </div>
        <div class="row tertiary-row">
            <div class="col-xl-6">
                <?php
                    $charityNumber = get_field('company_number', 'option');
                    $charityNumber = substr($charityNumber, 3);
                ?>
                <p class="bottom-info">&copy; North East Scotland College. Recognised  as a Scottish charity – number <a href="<?= "https://www.oscr.org.uk/about-charities/search-the-register/charity-details?number=" . $charityNumber ?>" target="_blank"><?php the_field('company_number', 'option') ?></a></p>
            </div>
            <div class="col-xl-6 text-xl-right">
                <?php
                if (has_nav_menu('bottom_bar_menu')) {
                    wp_nav_menu(['theme_location' => 'bottom_bar_menu']);
                }
                ?>
                <p class="website-by">website by <?= do_shortcode( '[blue2_logo type="light"]' ); ?></p>
            </div>
        </div>
    </div>
</footer>
