<?php
$relationshipPost = get_sub_field('block_post_relationship');
if($relationshipPost) {
    $relationshipID = $relationshipPost[0];
    $postType = get_post_type($relationshipID);
    $image = get_the_post_thumbnail_url($relationshipID);

    if($image){
        $image = get_the_post_thumbnail_url($relationshipID);
        $imageClass = "featured";
    } else{
        $image = get_field('default_image_logo', 'option');
        $imageClass = "not-featured";
    }
    $excerpt = get_the_excerpt($relationshipID);
    ?>
    <div class="split-block-section post-relationship-block">
        <div class="post-relationship-container">

            <div class="img-holder">
                <img src="<?= $image; ?>" alt="<?= get_the_title($relationshipID); ?>" class="<?= $imageClass; ?>">
            </div>
            <h3>
                <a href="<?= get_the_permalink($relationshipID); ?>"><?= get_the_title($relationshipID); ?></a><?= get_template_part('templates/pins/pin-post'); ?>
            </h3>
            <div class="post-info">
                <ul role="list">
                    <li>
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                    </span>
                    </li>
                    <?php if ($postType == 'event') {
                        if (have_rows('event_dates', $relationshipID)) { ?>
                            <?php while (have_rows('event_dates', $relationshipID)) {
                                the_row(); ?>
                                <li role="listitem"><?php the_sub_field('event_date', $relationshipID); ?></li>
                            <?php } ?>
                        <?php }
                    } else { ?>
                        <li role="listitem"><?= the_date(); ?></li>
                    <?php } ?>
                </ul>
                <?php
                $locations = get_field('related_locations', $relationshipID);
                if ($locations) { ?>
                    <ul role="list">
                        <li>
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                        </span>
                        </li>
                        <?php
                        if (count($locations) == 1) {
                            foreach ($locations as $post) { ?>
                                <?php setup_postdata($post); ?>
                                <li role="listitem"><?php the_title(); ?></li>
                            <?php }
                        } else { ?>
                            <li role="listitem">Various Campuses</li>
                        <?php } ?>
                    </ul>
                    <?php wp_reset_postdata(); ?>
                <?php } ?>
            </div>
            <p><?= $excerpt; ?></p>
            <div class="text-cta">
                <a href="<?= get_the_permalink($relationshipID); ?>">Read More</a> <i
                        class="fal fa-long-arrow-right"></i>
            </div>
        </div>
    </div>
    <?php
}
wp_reset_postdata(); ?>
