<?php
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";

global $wp_query;
$postCount = $wp_query->current_post;

if($postCount >= 0 && $postCount <= 2){
    $postClass = 'col-lg-6 col-xl-4';
} else{
    $postClass = 'col-lg-6 col-xl-4 col-xxl-3';
}
?>

<article class="<?= $postClass; ?> news-col news-section">
    <div class="card">
        <article class="news-article">
            <div class="image-holder <?= $imageClass; ?>">
                <?= get_template_part('templates/pins/pin-post'); ?>
                <a href="<?php the_permalink(); ?>">
                    <img src="<?= $image; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                </a>
            </div>
            <div class="card-body">
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <?php Blue2\Scruffy\Controllers\EventController::outputEventEntries(); ?>
            </div>
        </article>
    </div>
</article>
