<?php
$categories = get_the_terms(get_the_id(), 'news-type');
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";

global $wp_query;
$postCount = $wp_query->current_post;
if (!is_paged() ) {
    if ($postCount >= 0 && $postCount <= 3) {
        $postClass = 'col-lg-6 col-xl-4';
    } else {
        $postClass = 'col-lg-6 col-xl-4 col-xxl-3';
    }
} else{
    $postClass = 'col-lg-6 col-xl-4 col-xxl-3';
}
?>

<div class="<?= $postClass; ?> news-col news-section">
    <div class="card">
        <article class="news-article">
            <div class="image-holder <?= $imageClass; ?>">
                <?= get_template_part('templates/pins/pin-post'); ?>
                <a href="<?php the_permalink(); ?>">
                <img src="<?= $image; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                </a>
            </div>
            <div class="card-body">
                <ul class="categories" role="list">
                    <?php
                    if($categories) {
                        foreach ($categories as $cat) {
                            $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                            <li data-pin-cat="<?= $cat->term_id;?>" role="listitem"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                        <?php }
                    }?>
                </ul>
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <h3 class="date"><?= get_the_date('d.m.y') ?></h3>
            </div>
        </article>
    </div>
</div>
