<?php
    // Personalisation cookies.
    $pInterests = 'empty';
    $postCount = 0;
    if (isset($_COOKIE["nescol_interests"])) {
        $pInterests = $_COOKIE["nescol_interests"];
        $pInterests = json_decode(html_entity_decode(stripslashes($pInterests)));
    }
    $hasPins = get_field('activate_personalisation_pins', 'option');
    $alignClass = ' align-items-center';
?>
<div class="info-boxes">
    <div class="container">
        <div class="primary-box box">
            <?php
                if ($hasPins) {
                    if ($pInterests !== 'empty') {
                        $alignClass='';
                    }
                }
              ?>
            <div class="row d-flex<?=$alignClass;?>">
                <div class="col-lg-6">

                    <?php
                    // Populate interests from cookie.
                    if (get_field('activate_personalisation_pins', 'option')) {
                        if ($pInterests !== 'empty') {
                            $pInterestsString = '';
                            foreach ($pInterests as $pInterest) {
                                $arr = explode('_', $pInterest);
                                $interestType = $arr[0];
                                $interestID = $arr[1];
                                if ($interestType == 'term') {
                                    $pintext = get_category($interestID);
                                    $pintext= $pintext->name;
                                } else {
                                    $pintext = get_the_title($interestID);
                                }
                                $pInterestsString.=$pintext.' | ';
                            } ?>
                              <div class="recommended-events not-card-columns d-flex flex-wrap row">
                              <?php
                              $loop = new WP_Query(array( 'post_type' => 'event'));
                            if ($loop->have_posts()) :

                                while ($loop->have_posts()) : $loop->the_post(); ?>
                                <?php
                                    $relatedLocs = get_field('related_locations');
                            $relatedLocString = '';
                            $showPost=0;

                            if ($relatedLocs) {
                                foreach ($relatedLocs as $relatedLoc) {
                                    $relatedLocString.= $relatedLoc->post_title.' ';
                                    if (strpos($pInterestsString, $relatedLoc->post_title) !== false) {
                                        $showPost=1;
                                        break;
                                    } else {
                                        $showPost=0;
                                    }
                                }
                                if ($showPost==1) {
                                    $postCount++;
                                    $eventImage = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
                                    $eventClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image"; ?>

                                        <div class="col">
                                             <div class="card">
                                                    <div class="featured-event">
                                                        <div class="image-holder <?= $eventClass; ?>">
                                                            <?= get_template_part('templates/pins/pin-post'); ?>
                                                            <a href="<?php the_permalink(); ?>">
                                                                <img src="<?= $eventImage; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                                                            </a>
                                                        </div>
                                                        <div class="card-body">
                                                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                            <?php Blue2\Scruffy\Controllers\EventController::getEventDates('short'); ?>
                                                            <?php Blue2\Scruffy\Controllers\EventController::getEventLocations('short'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                        <?php
                                }
                            }
                            if ($postCount > 3) {
                                break;
                            }
                            endwhile;
                            endif;
                            wp_reset_postdata(); ?>
                              </div>
                        <?php
                        }
                    }

                    if ($postCount < 1) {
                        ?>
                    <div class="image-container">
                        <div class="img-holder">
                            <?php
                            $primaryImageField = get_field('primary_box_image');
                        $imageURL = wp_get_attachment_image_src($primaryImageField['ID'], 'home-split-image');
                        $primaryImage = $imageURL[0] ? : get_field('default_image_logo', 'option');
                        $primaryImageAlt = get_post_meta($primaryImageField['id'], '_wp_attachment_image_alt', true); ?>
                            <img src="<?= $primaryImage; ?>" alt="<?php the_field('primary_box_title'); ?>">
                        </div>
                    </div>
                    <?php
                    } ?>
                </div>
                <div class="col-lg-6">
                    <?php
                    if ($postCount > 0) {
                        ?>
                        <h2><?php the_field('personalised_events_heading'); ?></h2>
                        <?php the_field('personalised_events_intro'); ?>
                        <div class="text-cta">
                            <a href="/events/"><span class="underline">View more events</span><i class="fal fa-long-arrow-right"></i></a>
                        </div>
                        <?php
                    } else {
                        ?>
                    <h2><?php the_field('primary_box_title'); ?></h2>
                    <?php the_field('primary_box_description');
                        $primaryCTA = get_field('primary_box_cta');
                        if ($primaryCTA) { ?>
                        <div class="text-cta">
                            <a href="<?= $primaryCTA['url']; ?>"><span class="underline"><?= $primaryCTA['title']; ?></a></span><i class="fal fa-long-arrow-right"></i></a>
                        </div>
                    <?php }
                    }
                    ?>
                </div>
            </div>
        </div>
        <div class="secondary-box box">
            <div class="row d-flex align-items-center">
                <div class="col-lg-6 order-2 order-lg-1">
                    <h2><?php the_field('secondary_box_title'); ?></h2>
                    <?php
                    the_field('secondary_box_description');
                    $hide = get_field('secondary_hide_locations_list');
                    if (!$hide) { ?>
                        <div class="lists">
                            <?php $learningCentres = new WP_Query([
                                'post_type' => 'location',
                                'posts_per_page' => 50,
                                'orderby' => 'title',
                                'order' => 'ASC',
                                'tax_query' => [
                                    [
                                        'taxonomy' => 'location-type',
                                        'field' => 'slug',
                                        'terms' => 'learning-centre',
                                    ]
                                ],
                            ]);

                            $campuses = new WP_Query([
                                'post_type' => 'location',
                                'posts_per_page' => 50,
                                'orderby' => 'title',
                                'order' => 'ASC',
                                'tax_query' => [
                                    [
                                        'taxonomy' => 'location-type',
                                        'field' => 'slug',
                                        'terms' => 'campus',
                                    ]
                                ],
                            ]);
                            $campuses = $campuses->posts;
                            $pinClass = get_field('activate_personalisation_pins', 'option') ? : 'no-pins';
                            if ($campuses) { ?>
                                <div class="location-block">
                                    <h3>Our Campuses</h3>
                                    <ul role="list">
                                        <?php foreach ($campuses as $post) { ?>
                                            <li class="<?= $pinClass; ?>" role="listitem"><?= get_template_part('templates/pins/pin-location'); ?><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                                <?php wp_reset_postdata();
                            } ?>

                            <?php $learningCentres = $learningCentres->posts;
                            if ($learningCentres) { ?>
                                <div class="location-block">
                                    <h3>Our Learning Centres</h3>
                                    <ul role="list">
                                        <?php foreach ($learningCentres as $post) { ?>
                                            <li role="listitem" class="<?= $pinClass; ?>"><?= get_template_part('templates/pins/pin-location'); ?><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                                <?php wp_reset_postdata();
                            } ?>
                        </div>
                    <?php } ?>
                    <?php $secondaryCTA = get_field('secondary_box_cta');
                    if ($secondaryCTA) { ?>
                        <div class="text-cta">
                            <a href="<?= $secondaryCTA['url']; ?>"><?= $secondaryCTA['title']; ?></a><i class="fal fa-long-arrow-right"></i>
                        </div>
                    <?php } ?>
                </div>
                <div class="col-lg-6 order-1 order-lg-2 image-container">
                    <div class="img-holder">
                        <?php
                        $secondaryImageField = get_field('secondary_box_image');
                        $imageURL = wp_get_attachment_image_src($secondaryImageField['ID'], 'home-split-image');
                        $secondaryImage = $imageURL[0] ? : get_field('default_image_logo', 'option');
                        $secondaryImageAlt = get_post_meta($secondaryImage, '_wp_attachment_image_alt', true);
                        if ($secondaryImage) { ?>
                            <img src="<?= $secondaryImage ?>" alt="<?= $secondaryCTA['title'] ?? ''; ?>">
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
