<?php
$locations = Blue2\Scruffy\Site::getAllLocations();

$smaID = get_term_by('slug', 'sma', 'mode-of-study')->term_id;
$modeOfStudyArgs = ['taxonomy' => 'mode-of-study', 'exclude' => $smaID];
$modesOfStudy = get_terms($modeOfStudyArgs);

$levels = get_terms('level');
$categories = Blue2\Scruffy\Site::getAllNonParentCategories();
$courses = Blue2\Scruffy\Controllers\CourseController::getAllCourses();

$sortedLevels = [];
foreach($levels as $level){
    if(strpos($level->slug, 'broadly') === false){
        $sortedLevels[] = $level;
    }
}

?>
<div class="container">
    <div class="course-filter">
        <form id="course-filter-form">
            <div class="filter-by-options-label">
                <div class="filter-item first-item">
                    Filter <span class="d-none d-lg-inline">&nbsp;by:</span>
                </div>
            </div>

            <div class="custom-filters" id="check">
                <button class="close-filters--mobile d-lg-none"><i class="fal fa-times"></i><span class="sr-only">Close menu</span></button>

                <div class="filter-item">
                    <?php \Blue2\Scruffy\Controllers\CourseController::generateLocationSelect($locations); ?>
                </div>

                <div class="filter-item">
                    <?php \Blue2\Scruffy\Controllers\CourseController::generateTaxSelect($modesOfStudy, 'mode-of-study', 'Mode of Study') ?>
                </div>

                <div class="filter-item">
                    <?php \Blue2\Scruffy\Controllers\CourseController::generateTaxSelect($sortedLevels, 'level', 'Level') ?>
                </div>

                <div class="filter-item">
                    <?php \Blue2\Scruffy\Controllers\CourseController::generateTaxSelect($categories, 'interests', 'Interests') ?>
                </div>

                <div class="filter-item keyword-box">
                    <div class="keyword-holder">
                        <input name="keyword" type="text" placeholder="Keyword" class="keyword-search" value="<?php if(isset($_GET['keyword'])) { echo $_GET['keyword']; } ?>">
                        <i class="far fa-search"></i>
                    </div>
                </div>
            </div>

            <div class="az-filter">
                <div class="radio-item <?= !isset($_GET['letter']) || $_GET['letter'] == '' ? 'checked-radio' : ''; ?>">
                    <label for="all">ALL</label>
                    <input class="filter-radio" type="radio" id="all" name="letter" value="" <?= !isset($_GET['letter']) || $_GET['letter'] == '' ? 'checked' : ''; ?>>
                </div>
                <div class="radio-item <?= isset($_GET['letter']) && $_GET['letter'] == '1-10' ? 'checked-radio' : ""; ?>">
                    <label for="number">1-10</label>
                    <input class="filter-radio" type="radio" id="number" name="letter" value="1-10">
                </div>
                <?php foreach (range('A', 'Z') as $char) { ?>
                    <div class="radio-item <?= isset($_GET['letter']) && $_GET['letter'] == $char ? 'checked-radio' : ""; ?>">
                        <label for="<?= $char; ?>"><?= $char; ?></label>
                        <input class="filter-radio" type="radio" data-label="<?= $char; ?>" id="<?= $char; ?>" name="letter" value="<?= $char; ?>" <?= isset($_GET['letter']) && $_GET['letter'] == $char ? 'checked' : ""; ?>>
                    </div>
                <?php } ?>
            </div>

            <div class="filter-by-submit-button">
                <div class="filter-item last-item">
                    <input type="submit" value="Filter Courses" class="filter-button">
                </div>
            </div>
        </form>
    </div>
</div>

<div class="active-course-filters" id="active-filters">
    <div class="container">
        <div class="offset-lg-1">
            <ul role="list">
                <?php if(isset($_GET['campus']) && $_GET['campus'] !== ""){
                    $title = get_the_title($_GET['campus']);
                    $slug = str_replace(' ', '-', strtolower($title));
                    $filterName = 'campus'; ?>
                    <li role="listitem" class="filter-property" id="<?= $filterName ?>"><?= $title; ?><div data-value="<?= $slug; ?>" data-name="<?= $filterName; ?>" class="clear-filter" aria-label="Clear filter"><i class="fas fa-times"></i></div></li>
                <?php }
                if(isset($_GET['mode-of-study']) && $_GET['mode-of-study'] !== ""){
                    $filterName = 'mode-of-study';
                    $term = get_term_by('slug', $_GET['mode-of-study'], $filterName);
                    ?>
                    <li role="listitem" class="filter-property" id="<?= $filterName ?>"><?= $term->name; ?><div data-value="<?= $term->slug; ?>" data-name="<?= $filterName; ?>" class="clear-filter" aria-label="Clear filter"><i class="fas fa-times"></i></div></li>
                <?php }
                if(isset($_GET['interests']) && $_GET['interests'] !== ""){
                    $filterName = 'interests';
                    $term = get_term_by('slug', $_GET['interests'], 'category');
                    ?>
                    <li role="listitem" class="filter-property" id="<?= $filterName ?>"><?= $term->name; ?><div data-value="<?= $term->slug; ?>" data-name="<?= $filterName; ?>" class="clear-filter" aria-label="Clear filter"><i class="fas fa-times"></i></div></li>
                <?php }
                if(isset($_GET['level']) && $_GET['level'] !== ""){
                    $filterName = 'level';
                    $term = get_term_by('slug', $_GET['level'], $filterName);
                    ?>
                    <li role="listitem" class="filter-property" id="<?= $filterName ?>"><?= $term->name; ?><div data-value="<?= $term->slug; ?>" data-name="<?= $filterName; ?>" class="clear-filter" aria-label="Clear filter"><i class="fas fa-times"></i></div></li>
                <?php } ?>
                <li role="listitem" class="clear-all" aria-label="Remove all filters">Clear All Filters</li>
            </ul>
        </div>
    </div>
</div>

