<?php
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$homeCheck = is_front_page() ? "home-success" : 'home-fail';
$logo = get_field('company_logo', 'option');
$navLayout = is_front_page() ? 'front-page-true' : 'front-page-false';
$pinActiveClass = get_field('activate_personalisation_pins', 'option') ? 'personalisation-enabled' : 'personalisation-disabled';

// Personalisation cookies.
if(isset($_COOKIE["nescol_interests"])){
    $pInterests = $_COOKIE["nescol_interests"];
    $pInterests = json_decode(html_entity_decode(stripslashes ($pInterests)));
}

if(isset($_COOKIE['nescol_postCats'])){
    $pPostCats = $_COOKIE['nescol_postCats'];
    $pPostCats = json_decode(html_entity_decode(stripslashes ($pPostCats)));
}

if(isset($_COOKIE['nescol_posts'])){
    $pPosts = $_COOKIE['nescol_posts'];
    $pPosts = json_decode(html_entity_decode(stripslashes ($pPosts)));
}

$siteWideNotification = get_field('site_wide_notification','option');

//var_dump(json_decode("'".$pInterests."'", true));

?>
<a class="skip-main" href="#main-area">Skip to main content</a>
<header role="banner" class="site-header">
    <?php if(get_field('activate_personalisation_pins', 'option')) { ?>
    <div class="settings-drawer" id="settings-drawer">
        <?php
            //$taxes = get_taxonomies();
            $taxes = get_terms( 'news-type', array(
            'hide_empty' => false,
            ) );
            echo '<div id="post_Details" class="d-none">';
            foreach($taxes as $tax) {
                $taxLink = get_category_link($tax->term_id);
                $taxColour = get_field('category_colour', 'news-type_' . $tax->term_id);
                $taxName = $tax->name;
                echo '<div class="post_detail" id="post_detail-'.$tax->term_id.'" data-tax-link="'.$taxLink.'" data-tax-colour='.$taxColour.' data-tax-name="'.$taxName.'"></div>';
            }
            echo '</div>';
        ?>
        <div class="settings__header">
            <p class="lead">Your Interests</p>
            <p class="small">Anything you want to see more info on and keep up to date with.</p>
        </div>
        <div class="settings__course-subjects">
            <ul class="swiper-wrapper">
                <?php 
                  // Populate interests from cookie.
                  if(isset($_COOKIE["nescol_interests"])){
                      foreach($pInterests as $pInterest) {
                          $arr = explode('_',$pInterest);
                          $interestType = $arr[0];
                          $interestID = $arr[1];
                          $pinlink='';
                          if ($interestType == 'term'){
                             $pintext = get_category($interestID);
                             $baseURL =  "http://" . $_SERVER['SERVER_NAME'] .'/';
                             $pinlink = $baseURL.$pintext->slug;
                             $pintext= $pintext->name;
                             
                          }else{
                              $pintext = get_the_title($interestID);
                              $pinlink = get_the_permalink($interestID);
                          }
                          ?>
                          
                          <li class="swiper-slide pinned-interests__slide" id="p-loc-slide-<?=$pInterest;?>">
                            <span class="pin pin-interest unpin" data-pin-id="<?=$pInterest;?>">
                            <span class="fa-stack"><i class="fas fa-circle fa-stack-2x"></i>
                            <i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i>
                            </span></span><span><a href="<?= $pinlink;?>"><?= $pintext;?></a></span>
                        </li>
                          <?php
                    }
                  }   
                ?>
                <li class="swiper-slide pinned-interests__slide pinned-interests__slide--placeholder"><span>Add interests.</span></li>
            </ul>
        </div>
        <div class="settings__controls">
            <button id="settings__reset" class="settings__reset">Reset <i class="fa fa-trash"></i></button>
            <button id="settings__reset" class="settings__close">Close <i class="fa fa-times"></i></button>
            <button id="settings__expand" class="settings__expand">Expand <i class="fa fa-expand-alt"></i></button>
            <button id="settings__compress" class="settings__compress d-none">Reduce <i class="fa fa-compress-alt"></i></button>
            <span class="settings__note">This info is stored with cookies.</span>
        </div>
        <div class="settings__expander">
            <div class="settings__catergories">
                <ul class="categories">
                    <?php
                        if(isset($_COOKIE['nescol_postCats'])){    
                            foreach($pPostCats as $pPostCat) {
                                if ($pPostCat!==NULL){
                                    $category = get_term($pPostCat);
                                    $categoryColour = get_field('category_colour', 'news-type_' . $category->term_id);
                                    
                                    ?>
                                    
                                    <li id="p_cat-<?=$pPostCat;?>">
                                        <span class="pin pin-cat unpin">
                                            <span class="fa-stack">
                                                <i class="fas fa-circle fa-stack-2x"></i> 
                                                <i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i>
                                            </span>
                                        </span>
                                        <a href="/news-type/<?=$category->slug;?>/" style="background-color:<?=$categoryColour;?>;" aria-label="Open Courses Category">
                                            <?= $category->name; ?>
                                        </a>
                                    </li>
                                    <?php
                                }
                            }
                        }
                    ?>
                </ul>
            </div>
            <div class="settings__pinned-posts">
                <div class="swiper-wrapper">
                    <?php
                        if(isset($_COOKIE['nescol_posts'])){
                            foreach($pPosts as $pPost) {
                                $categories = get_the_terms($pPost, 'news-type');
                                $courseLevels = get_the_terms($pPost, 'level');
                                $customCourseLevel = get_field('qualification_type',$pPost);
                                $image = get_the_post_thumbnail_url($pPost) ? get_the_post_thumbnail_url($pPost, 'news-image') : get_field('default_image_logo', 'option');
                                ?>
                                <article class="swiper-slide pinned-post-slide" id="p-post-slide-<?=$pPost;?>">
                                    <div class="news-item">
                                        <a href="<?php the_permalink($pPost); ?>" aria-label="Open <?= get_the_title($pPost); ?> Article">
                                            <div class="image-area">
                                                <span class="pin pin-post unpin" data-post-id="<?=$pPost;?>">
                                                    <span class="fa-stack">
                                                        <i class="fas fa-circle fa-stack-2x"></i>
                                                        <i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i>
                                                    </span>
                                                </span>
                                                <?php
                                                    if ($courseLevels || $customCourseLevel){
                                                        ?>
                                                        <ul class="categories">
                                                            <?php
                                                            if($courseLevels){
                                                                 foreach($courseLevels as $courseLevel) { 
                                                            ?>
                                                                <li><span class="qualification"><?= $courseLevel->name; ?></span></li>
                                                            <?php 
                                                                }
                                                            }elseif($customCourseLevel){  
                                                            ?>
                                                            <li><span class="qualification"><?= $customCourseLevel; ?></span></li>
                                                            <?php
                                                                }
                                                            ?>
                                                        </ul>
                                                <?php
                                                    }else{
                                                        ?>
                                                        <img src="<?= $image; ?>" alt="<?= get_the_title($pPost); ?>">
                                                <?php 
                                                    }
                                                ?>
                                            </div>
                                        </a>
                                        <div class="content-area">
                                            <?php if($categories) { ?>
                                                <ul class="categories">
                                                    <?php foreach($categories as $cat) {
                                                        $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                                        <li data-pin-cat="<?= $cat->term_id;?>"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                                                    <?php } ?>
                                                </ul>
                                            <?php } ?>
                                            <h3><a href="<?php the_permalink($pPost); ?>" aria-label="Open <?= get_the_title($pPost) ?> Article"><?= get_the_title($pPost) ?></a></h3>
                                            <?php
                                                if ($courseLevels || $customCourseLevel){
                                                    $page_data = get_page($pPost);
                                                    if ($page_data) {
                                                        echo '<p>'.$page_data->post_content.'</p>';
                                                    }
                                                }
                                            ?>
                                            <?php Blue2\Scruffy\Controllers\EventController::getEventDates('short',$pPost); ?>
                                            <?php Blue2\Scruffy\Controllers\EventController::getEventLocations('short',$pPost); ?>
                                        </div>
                                    </div>
                                </article>
                                <?php
                            }
                        }
                    ?>
                    
                    <article class="swiper-slide pinned-post-slide--placeholder">
                        <div class="news-item">
                            <div class="image-area ">
                                <?php
                                    $image = get_field('default_image_logo', 'option');
                                    ?>
                                    <img src="<?= $image; ?>" alt="">
                            </div>                               
                            <div class="content-area">
                                <h3><span>Add news, events &amp; more.</span></h3>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="header-container <?= $navLayout; ?>">
        <div class="nescol-nav">
            <div class="logo-holder">
                <a href="<?= home_url('/'); ?>">
                    <img src="<?= $logo['url']; ?>" alt="North East Scotland College">
                </a>
            </div>
            <div class="menu-holder">
                <nav class="external-resources-navigation" role="navigation" aria-label="External resources navigation">
                    <?php
                    if (has_nav_menu('external_resources')) {
                        wp_nav_menu(['theme_location' => 'external_resources']);
                    }
                    ?>
                    <div class="header-tools">
                        <?php if(get_field('activate_personalisation_pins', 'option')) { ?>
                        <div class="pin-drawer-toggle-wrapper">
                            <button aria-label="View pinned items" class="pin-items">
                                <i class="far fa-thumbtack fa-2x"></i>
                            </button>
                        </div>
                        <?php } ?>
                        <button aria-label="Activate the search bar" class="activate-search <?= $pinActiveClass; ?>">
                            <i class="far fa-search fa-2x"></i>
                        </button>
                    </div>
                    <div class="search-holder__form">
                        <form class="custom-search-bar" action="<?= home_url(); ?>" role="search">
                            <input type="text" name="s" aria-label="Search" id="header-search" placeholder="Enter search term" />
                        </form>
                        <button aria-label="Close the search bar" class="remove-search">
                            <i class="far fa-times fa-2x"></i>
                        </button>
                    </div>
                    
                </nav>
                <nav class="main-navigation" role="navigation" aria-label="Primary navigation">
                    <button class="close-nav--mobile d-lg-none"><i class="fal fa-times"></i><span class="sr-only">Close menu</span></button>
                    <?php
                    if (has_nav_menu('main_menu')) {
                        wp_nav_menu(['theme_location' => 'main_menu']);
                    }
                    ?>
                </nav>
            </div>
        </div>
    </div>
    <div class="d-md-block d-lg-none mobile-navigation">
        <div class="container">
            <div class="mobile-nav-holder">
                <div class="mobile-nav-logo">
                    <a href="<?= home_url('/'); ?>">
                        <img src="<?= $logo['url']; ?>" alt="North East Scotland College">
                    </a>
                </div>
                <div class="header-tools">
                    <?php if(get_field('activate_personalisation_pins', 'option')) { ?>
                        <button aria-label="View pinned items" class="pin-items">
                            <i class="far fa-thumbtack fa-2x"></i>
                        </button>
                    <?php } ?>
                    <button aria-label="Activate the search bar" class="activate-search">
                        <i class="far fa-search fa-2x"></i>
                    </button>
                </div>
                <div class="mobile-navigation-controls">
                    <div class="mobile-nav-menu-open">
                        <i class="far fa-bars fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="search-holder__form--mobile">
                <form class="custom-search-bar" action="<?= home_url(); ?>" role="search">
                    <input type="text" name="s" id="header-search--mob" aria-label="Search" placeholder="Enter search term" />
                </form>
                <button aria-label="Close the search bar" class="remove-search">
                    <i class="far fa-times fa-2x"></i>
                </button>
            </div>
        </div>
        <div class="mobile-menu-output">
            <div class="container">
                <!--                <nav class="mobile-navigation" role="navigation" aria-label="Mobile navigation">-->
                <!--                    --><?php
                //                    if (has_nav_menu('mobile_menu')) {
                //                        wp_nav_menu(['theme_location' => 'mobile_menu']);
                //                    }
                //                    ?>
                <!--                </nav>-->
            </div>
        </div>
    </div>
    <?php
    if ($siteWideNotification) {
         get_template_part('templates/sections/notification-bar');
    }else{
        if(is_front_page()){
            get_template_part('templates/sections/notification-bar');
        }
    }
    $systemMaintenance = get_field('enable_system_maintenance_mode', 'option');
    if($systemMaintenance) { ?>
    <div class="system-maintenance-banner"><i class="fal fa-exclamation-circle"></i> <?php the_field('system_maintenance_message', 'option'); ?></div>
    <?php } ?>
</header>


