<?php
$title = get_sub_field('hero_title_override') ? : get_the_title();
$heroLayout = get_sub_field('hero_layout');
$includeBreadcrumbs = get_sub_field('include_breadcrumbs');
$heroVideo = get_sub_field('hero_video');
$image = get_the_post_thumbnail_url(get_the_id(), 'hero-image');
?>
<div class="flexible-layout-block hero-block <?= $heroLayout; ?>" style="background-image:url('<?= $image; ?>');">

    <?php if($heroVideo){ ?>
        <video autoplay muted loop id="hero-video" poster="<?= $image; ?>">
            <source src="<?= $heroVideo['url']; ?>" type="video/mp4">
        </video>
    <?php } ?>

    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-cyan-vertical.svg'); ?>
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-right-red.svg'); ?>

    <div class="hero-cont container<?php if($heroLayout == 'hero-2') { ?> d-flex align-items-center<?php } ?>">
        <div class="hero-block-section">
            <?php if($includeBreadcrumbs && function_exists('yoast_breadcrumb')) {
                yoast_breadcrumb( '<p class="custom-breadcrumbs">','</p>' );
            } ?>
            <h1><?= $title; ?></h1>
            <?php the_content(); ?>
        </div>
        <?php if($heroLayout == 'hero-2') { ?>
            <div class="svg-holder horizontal">
                <i class="fas fa-chevron-double-left fa-5x"></i>
            </div>
        <?php }  else { ?>
            <div class="svg-holder vertical">
                <i class="fas fa-chevron-double-down fa-10x"></i>
            </div>
        <?php } ?>
    </div>
</div>
