<?php $featuredHomePosts = get_field('featured_home_post'); ?>
<div class="featured-news-events">
    <div class="container">
        <?php if(get_field('featured_content_title')) { ?>
            <h2><?php the_field('featured_content_title') ?></h2>
        <?php } if(get_field('featured_introduction')) { ?>
            <div class="featured-intro"><?php the_field('featured_introduction') ?></div>
        <?php } ?>
        <section class="featured-post">
            <div class="row d-flex align-items-center">
                <?php
                if($featuredHomePosts) {
                    foreach ($featuredHomePosts as $post) {
                        setup_postdata($post);
                        $postType = get_post_type();
                        $excerpt = get_the_excerpt();
                        $image = get_the_post_thumbnail_url();
                        if ($image) {
                            $image = get_the_post_thumbnail_url();
                            $imageClass = "featured";
                        } else {
                            $image = get_field('default_image_logo', 'option');
                            $imageClass = "not-featured";
                        } ?>
                        <div class="col-lg-6">
                            <div class="image-holder <?= $imageClass; ?>">
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-red.svg'); ?>
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-cyan.svg'); ?>
                                <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <h3>
                                <a href="<?php the_permalink(); ?>"><?= get_the_title() . ' (' . ucwords($postType) . ')'; ?></a><?= get_template_part('templates/pins/pin-post'); ?>
                            </h3>
                            <p><?= $excerpt; ?></p>
                            <div class="text-cta">
                                <a href="<?php the_permalink(); ?>"><span class="underline">Read More</span><i
                                            class="fal fa-long-arrow-right"></i></a>
                            </div>
                        </div>
                    <?php }
                }
                wp_reset_postdata(); ?>
        </section>
    </div>
</div>