<?php
$blockRatio = get_sub_field('block_ratio');
$blockBackgroundColour = get_sub_field('block_background_colour');
$blockTextColour = get_sub_field('block_text_colour');
$blockBackgroundImage = get_sub_field('block_background_image');
$areaClass = "";

$bgSet = $blockBackgroundColour || $blockBackgroundImage ? 'bg-set' : 'bg-not-set';

if($blockBackgroundImage) {
    $background = 'background-image:url(' . $blockBackgroundImage['url'] . ');';
} else{
    $background = 'background:' . $blockBackgroundColour;
}

switch ($blockRatio) {
    case '75-25':
        $primaryBlockCol = 'col-lg-8';
        $secondaryBlockCol = 'col-lg-4';
        break;
    case '25-75':
        $primaryBlockCol = 'col-lg-4';
        $secondaryBlockCol = 'col-lg-8';
        break;
    case '50-50':
        $primaryBlockCol = 'col-lg-6';
        $secondaryBlockCol = 'col-lg-6';
        break;
    case '100':
        $primaryBlockCol = 'col-lg-12';
        $secondaryBlockCol = "";
        $areaClass = "full";
        break;
}
$primaryBlockType = get_sub_field('primary_block_type');
$secondaryBlockType = get_sub_field('secondary_block_type');
?>
<section class="<?= $bgSet; ?> split-block-section-holder <?= $areaClass ?>" style="<?= $background ?>; color:<?= $blockTextColour; ?>;">
    <div class="container">
        <div class="row">
            <div class="<?= $primaryBlockCol; ?>">
                <?php
                if( have_rows('primary_item') ) {
                    while ( have_rows('primary_item') ) {
                        the_row();
                        get_template_part('templates/flexible_layout/split-block-sections/' . $primaryBlockType . '-block');

                    }
                }
                ?>
            </div>
            <div class="<?= $secondaryBlockCol; ?>">
                <?php
                if( have_rows('secondary_item') ) {
                    while (have_rows('secondary_item')) {
                        the_row();
                        get_template_part('templates/flexible_layout/split-block-sections/' . $secondaryBlockType . '-block');
                    }
                }
                ?>
            </div>
        </div>
    </div>
</section>
