<?php
$news = get_field('featured_post');
if($news){
    $news = get_field('featured_post');
} else{
    $news = get_sub_field('featured_post');
}
if( $news ){ ?>
    <div class="featured-news-events">
        <div class="container">
            <section class="featured-post">
                <?php if(get_field('news_title') || get_field('news_description')) { ?>
                    <div class="title-section">
                        <h2><?php the_field('news_title'); ?></h2>
                        <?php the_field('news_description'); ?>
                    </div>
                <?php } ?>
                <div class="row d-flex align-items-center">
                    <?php foreach( $news as $post){
                        setup_postdata($post);
                        $postType = get_post_type();
                        $excerpt = get_the_excerpt();
                        $image = get_the_post_thumbnail_url();
                        if($image){
                            $image = get_the_post_thumbnail_url();
                            $imageClass = "featured";
                        } else{
                            $image = get_field('default_image_logo', 'option');
                            $imageClass = "not-featured";
                        }
                        ?>
                        <div class="col-lg-6">
                            <div class="image-holder <?= $imageClass; ?>">
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-red.svg'); ?>
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-cyan.svg'); ?>
                                <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a><?= get_template_part('templates/pins/pin-post'); ?></h3>
                            <div class="post-info">
                                <ul role="list">
                                    <li>
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </li>
                                    <?php
                                    $eventEntries = get_field('event_dates');
                                    if($postType == 'event') {
                                        if($eventEntries) {
                                            if(count($eventEntries) > 1){ ?>
                                                <li role="listitem">Various Dates/Locations</li>
                                            <?php } else { ?>
                                                <li role="listitem"><?= $eventEntries[0]['event_date']; ?></li>
                                            <?php }
                                        } ?>
                                    <?php } else { ?>
                                        <li role="listitem"><?= the_date(); ?></li>
                                        <?php
                                    } ?>
                                </ul>
                                <?php
                                $locations = get_field('related_locations');
                                if( $locations  && $postType == 'post'){ ?>
                                    <ul role="list">
                                        <li>
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                                        </span>
                                        </li>
                                        <?php
                                        if(count($locations) == 1) {
                                            foreach ($locations as $post) { ?>
                                                <?php setup_postdata($post); ?>
                                                <li role="listitem"><?php the_title(); ?></li>
                                            <?php }
                                        } else { ?>
                                            <li role="listitem">Various Campuses</li>
                                        <?php } ?>
                                    </ul
                                <?php } elseif($postType == 'event' && count($eventEntries) == 1) { ?>
                                <ul role="list">
                                    <li>
                                        <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                                        </span>
                                    </li>
                                    <li role="listitem"><?= $eventEntries[0]['event_location']; ?></li>
                                </ul>
                                <?php } ?>
                            </div>
                            <p><?= $excerpt; ?></p>
                            <div class="text-cta">
                                <a href="<?php the_permalink(); ?>"><span class="underline">Read More</span><i class="fal fa-long-arrow-right"></i></a>
                            </div>
                        </div>
                    <?php }
                    wp_reset_postdata(); ?>
            </section>
        </div>
    </div>
<?php } ?>
