<?php
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$courses = Blue2\Scruffy\Controllers\CourseController::getAllCourses(null, $paged, null, null);
?>
<div class="course-archive-custom" id="main-area">
    <div class="courses-hero" style="background-image:url('<?php the_field('course_archive_background_image', 'option'); ?>');">
        <div class="container d-flex align-items-center">
            <div class="title-section">
                <?php if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb( '<p class="custom-breadcrumbs">','</p>' );
                } ?>
                <h1><?php the_field('course_archive_hero_title', 'option'); ?></h1>
                <?php the_field('course_archive_hero_content', 'option'); ?>
            </div>
        </div>
    </div>
    <?php get_template_part('templates/sections/course/course-filter'); ?>
    <div class="loading text-center">
        <div class="ajax-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
    </div>
    <main class="course-output container" id="course-output" role="main">
        <?php Blue2\Scruffy\Controllers\CourseController::outputCourses($courses); ?>
    </main>
</div>
