<?php
$categories = Blue2\Scruffy\Site::getAllNonParentCategories();
$infoBlocks = get_field('informational_blocks');
$wideSVGs = ['wide-green', 'wide-red', 'wide-yellow'];
$tallSVGs = ['tall-cyan', 'tall-green', 'tall-red'];

$infoBlocksIndex = [];
$count = 0;

if($infoBlocks) {
    foreach ($infoBlocks as $block) {
        while (count($infoBlocksIndex) < count($infoBlocks)) {
            $random = mt_rand(0, count($categories) - 1);
            if (!in_array($random, $infoBlocksIndex)) {
                $infoBlocksIndex[$count] = $random;
                $count++;
            }
        }
    }
}
?>
<div class="courses-by by-interest">
    <?= get_template_part('templates/sections/courses-by/courses-by-hero'); ?>
    <?= get_template_part('templates/sections/courses-by/courses-by-filter'); ?>
    <main class="course-by-interest-output" role="main" id="main-area">
        <div class="container">
            <div class="row">
                <?php
                foreach($categories as $key => $category){
                    $categoryParent = get_term($category->parent);
                    $categoryColour = get_field('category_colour', 'category_' . $categoryParent->term_id) ? : "#623C7C";
                    $imageID = get_field('category_image', 'category_' . $category->term_id);
                    $imageSource = wp_get_attachment_image_src($imageID, 'news-image');
                    $categoryImage = $imageSource[0] ? : get_field('default_image_logo', 'option');
                    $partTimeCount = Blue2\Scruffy\Site::getCourseCount('part-time', $category->slug);
                    $fullTimeCount = Blue2\Scruffy\Site::getCourseCount('full-time', $category->slug);
                    ?>
                    <div class="col-lg-6 col-xl-4 col-xxxl-3 by-interest-col">
                        <div class="by-interest-single">
                            <div class="image-area <?php if($categoryImage == get_field('default_image_logo', 'option')) { echo 'default-category-image'; } ?>">
                                <img src="<?= $categoryImage; ?>" alt="<?= $category->name; ?>">
                            </div>
                            <div class="content-area">
                                <span class="parent-category" style="background-color:<?= $categoryColour; ?>"><?= $categoryParent->name; ?></span>
                                <h2><a href="<?= "/courses/?interests=" . $category->slug ?>" aria-label="<?= 'View ' . $category->name . ' courses' ?>"><?= $category->name; ?></a></h2>
                                <div class="by-interest-bottom">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <?php if($fullTimeCount > 0) { ?>
                                                <div class="course-count"><?= $fullTimeCount; ?></div>
                                                <a href="<?= "/courses/?interests=" . $category->slug  . "&mode-of-study=full-time"?>" aria-label="<?= 'View full-time ' . $category->name . ' courses'; ?>">Full-time Courses</a>
                                            <?php } ?>
                                        </div>
                                        <div class="col-lg-6">
                                            <?php if($partTimeCount > 0) { ?>
                                                <div class="course-count"><?= $partTimeCount; ?></div>
                                                <a href="<?= "/courses/?interests=" . $category->slug  . "&mode-of-study=part-time"?>" aria-label="<?= 'View part-time ' . $category->name . ' courses'; ?>">Part-time Courses</a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                    if(in_array($key, $infoBlocksIndex)){
                        $infoBlockItem = array_search($key, $infoBlocksIndex);
                        $randomWideSVG = $wideSVGs[mt_rand(0, count($wideSVGs)-1)];
                        $randomTallSVG = $tallSVGs[mt_rand(0, count($tallSVGs)-1)];
                        ?>
                        <div class="col-lg-6 col-xl-4 col-xxxl-3 by-interest-col info-block">
                            <div class="inner">
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/courses-by-blocks/' . $randomTallSVG .  '.svg'); ?>
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/courses-by-blocks/' . $randomWideSVG . '.svg'); ?>
                                <h2><?= $infoBlocks[$infoBlockItem]['title']; ?></h2>
                                <?= $infoBlocks[$infoBlockItem]['content'];  ?>
                            </div>
                        </div>
                    <?php } ?>
                <?php } ?>

            </div>
        </div>
    </main>
</div>
