<?php


namespace Blue2\Scruffy\Controllers;

use Blue2\Scruffy\Lib\SagePay;

class SMAController
{
    const FORM_ID = 8; //ID of SMA form
    const BOOKING_ID = 309; //ID of 'Are you booking as' question
    const PAYMENT_ID = 310; //ID of individual payment method
    const COMP_PAYMENT_ID = 311; //ID of company payment method
    
    public function __construct()
    {
        //add_action('ninja_forms_submit_data', [$this, "processPayment"]);
        add_action('ninja_forms_after_submission', [$this, "processPayment"]);
        add_filter('ninja_forms_submit_data', [$this, 'filterFormData']);
        add_action('wp', [$this, 'checkSagepay']);
    }

    public function processPayment($data)
    {
        //$sagepayURL = 'https://test.sagepay.com/gateway/service/vspform-register.vsp';
        $sagepayURL = 'https://live.sagepay.com/gateway/service/vspform-register.vsp';

        //Only run for SMA form
        if ($data['form_id'] == self::FORM_ID) {
            $submission = $data['fields'];
            $cost = 0;

            foreach ($submission as $submissionData) {
                if (preg_match('/_dates_[0-9]{13}/', $submissionData['key']) && preg_match('/[0-9]+\.[0-9]{2}/', $submissionData['value'], $cost)) {
                    $cost = $cost[0];
                    break;
                }
            }
            $postId = $data['actions']['save']['sub_id'];

            $onlineField = $submission[self::BOOKING_ID]['value'] == 'individual' ? $submission[self::PAYMENT_ID]['value'] : $submission[self::COMP_PAYMENT_ID]['value'];
            
            if ($onlineField == "pay online") {
                $sagePay = new SagePay();

                $sagePay->setCurrency('GBP');
                $sagePay->setVendorEMail('sma@nescol.ac.uk');
                $sagePay->setSendEMail(true);
                $sagePay->setVendorTxCode('SMA-'.$postId);
                update_post_meta($postId, '_field_417', 'SMA-'.$postId);
                $sagePay->setDescription('Scottish Maritime Academy Booking');
                $sagePay->setEMailMessage('Thank you for booking your course with the Scottish Maritime Academy at NESCol.');

                $url = home_url('/online-application-result');
                $sagePay->setSuccessURL($url);
                $sagePay->setFailureURL($url);

                $title = $submission[292]['value'];
                $firstname = $submission[293]['value'];
                $middlename = $submission[294]['value'];
                $lastname = $submission[295]['value'];
                    
                $sagePay->setBillingFirstnames($firstname. ' '. $middlename);
                $sagePay->setBillingSurname($lastname);
                $sagePay->setCustomerName("$title $firstname $lastname");
                $sagePay->setCustomerEMail($submission[299]['value']);
                $sagePay->setBillingAddress1($submission[302]['value']);
                $sagePay->setBillingAddress2($submission[303]['value']);
                $sagePay->setBillingCity($submission[304]['value']);
                $sagePay->setBillingPostCode($submission[305]['value']);
                $sagePay->setBillingCountry($submission[296]['value']);
                $sagePay->setBillingPhone($submission[300]['value']);
                $sagePay->setDeliverySameAsBilling();

                $sagePay->setAmount($cost);

                $crypt =$sagePay->getCrypt();
                    
                $details = 'VPSProtocol=3.00&TxType=PAYMENT&Vendor=aberdeencollege&Crypt='.$crypt;

                $redirect = $sagepayURL.'?'.$details;
                $data['redirect'] = $redirect;
                $data['cost'] = $cost;
                $response = array( 'data' => $data, 'errors' => [], 'debug' => [] );

                header('Content-Type: application/json');
                echo wp_json_encode($response);

                wp_die();
            }
        }
    }

    public function checkSagepay()
    {
        if (is_page('online-application-result') && isset($_GET['crypt'])) {
            $sagePay = new SagePay();

            $sagepayInfo = $sagePay->decode($_GET['crypt']);
            $postId = $this->loadBySagepayRef($sagepayInfo['VendorTxCode']);
            if ($postId) {
                update_post_meta($postId, '_field_418', $sagepayInfo['Status'].': '.$sagepayInfo['StatusDetail']);
            }
        }
    }

    private function loadBySagepayRef($ref)
    {
        $args = array(
            'post_type' => 'nf_sub',
            'fields' => 'ids',
            'meta_query' => array(
                array(
                    'key' => '_field_417',
                    'value' => $ref,
                    'compare' => '=',
                )
            )
         );
        $query = new \WP_Query($args);
        $data = $query->get_posts();

        return $data[0] ?? null;
    }
    
    public function filterFormData( $form_data ) {
        foreach( $form_data[ 'fields' ] as $field ) { 
            if( 'select_a_course_1571998524314' != $field[ 'key' ] ) continue; // Check the field key to see if this is the field that I need to update.

            //get our selected course and then break the loop
            $selected_course = $field[ 'value' ];
            break;
        }
        
        foreach( $form_data[ 'fields' ] as $field ) { 
            if('choose_payment_method_1572000313654' != $field['key']) continue; // Check the field key to see if this is the field that I need to update.

            //check our key is payment method
            if( 'choose_payment_method_1572000313654' == $field[ 'key' ] ) {
                if($selected_course == 'Trainee Deckhand') {
                    //if course is trainee deckhand, clear this value in case it was set
                    $field[ 'value' ] = '';
                }
            }          
        }

        return $form_data;
    }
}
