<?php

$locationArgs = [
    'post_type' => 'location',
    'posts_per_page' => 50,
    'orderby' => 'title',
    'order' => 'ASC',
    'tax_query' => [
        [
            'taxonomy' => 'location-type',
            'field' => 'slug',
            'terms' => ['campus', 'learning-centre'],
        ]
    ]
];

$locationsBlocks = get_sub_field('block_content');
$mainBg = get_template_directory_uri() . '/dist/images/statistics/statistics-main-bg.png';
$locations = new WP_Query($locationArgs);
$learningCentres = [];
$campuses = [];

if ( $locations->have_posts() ) {
    while ( $locations->have_posts() ) {
        $locations->the_post();

        $locationType = get_the_terms(get_the_id(), 'location-type');
        if($locationType[0]->name == 'Campus') {
            array_push($campuses, get_the_title());
        } else {
            array_push($learningCentres, get_the_title());
        }

    }
}
wp_reset_postdata(); ?>

<div class="split-block-section locations-block">
    <div class="locations-container" style="background-image:url('<?= $mainBg; ?>'); ">
        <div class="primary-section">
            <h2><?= $locations->post_count; ?></h2>
            <p>Locations</p>
        </div>
        <div class="row">
            <div class="col-xxl-6">
                <?php if($campuses) { ?>
                    <h3>Our Campuses</h3>
                    <ul role="list">
                        <?php foreach($campuses as $campus) { ?>
                            <li role="listitem"><?= get_template_part('templates/pins/pin-location') . " " . $campus; ?></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <div class="col-xxl-6">
                <?php if($learningCentres) { ?>
                    <h3>Our Learning Centres</h3>
                    <ul role="list">
                        <?php foreach($learningCentres as $centre) { ?>
                            <li role="listitem"><?= get_template_part('templates/pins/pin-location') . " " . $centre ; ?></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
