<?php
$image = get_field('company_logo_white', 'option');
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : $image['url'];
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
?>

<?= get_template_part('templates/sections/news-hero'); ?>

<main class="custom-news-single news-section custom-events-single" role="main" id="main-area">
    <div class="container">
        <div class="row">
            <div class="offset-xl-2 col-xl-8">
                <div class="single-feature-image image-holder <?= $imageClass ?>">
                    <?php if($image) { ?>
                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                    <?php } ?>
                </div>
                <div class="single-news-content">
                    <h1><?php the_title(); ?></h1>
                    <div class="single-event-lists">
                        <?php
                        $eventEntries = get_field('event_dates');
                        if($eventEntries) { ?>
                            <ul class="event-entries">
                                <?php foreach ($eventEntries as $entry) { ?>
                                    <li>
                                      <span class="fa-stack">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                                      </span>
                                        <span class="date"><?= $entry['event_date'] ?></span>
                                        <span class="time">(<?= $entry['event_start_time']; ?><?php if(!$entry['event_end_time']) { echo ')'; } ?> <?php if($entry['event_end_time']) { ?> - <?= $entry['event_end_time']; ?>) <?php } ?></span>
                                        <?php if($entry['event_location']) { ?><span class="location"> - <?= $entry['event_location'] ?></span><?php } ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                    <?php the_content(); ?>

                    <div class="view-more-stories view-more text-center">
                        <a href="/events/">View More Events</a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</main>

<?= get_template_part('templates/sections/post-gallery'); ?>

<?php $relatedArgs = [
    'post__not_in' => [get_the_id()],
    'post_type' => 'event',
    'posts_per_page' => 7,
];
$moreLikeThisCount = 0;
$moreLikeThis = new WP_Query($relatedArgs);
if ($moreLikeThis->have_posts()) { ?>
    <div class="more-articles">
        <div class="container">
            <h2 class="more-title">Other Events</h2>
            <div class="row d-flex justify-content-center" role="feed">
                <?php while ($moreLikeThis->have_posts()) {
                    $moreLikeThis->the_post();
                    $moreLikeThisCount++;
                    if($moreLikeThisCount >= 1 && $moreLikeThisCount <= 3){
                        $moreClass = 'col-lg-6 col-xl-4';
                    } else{
                        $moreClass = 'col-lg-6 col-xl-3';
                    }
                    $image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
                    $imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
                    ?>

                    <article class="<?= $moreClass; ?> news-col news-section">
                        <div class="card">
                            <article class="news-article">
                                <div class="image-holder <?= $imageClass; ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?= $image; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                                    </a>
                                </div>
                                <div class="card-body">
                                    <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                    <?php Blue2\Scruffy\Controllers\EventController::outputEventEntries(); ?>
                                </div>
                            </article>
                        </div>
                    </article>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php
} ?>
