<?php
$flexLayout = get_field('flexible_layout');
$newsRowClass = "";
if($flexLayout) {
    $count = count($flexLayout);
    $currentRowIndex = get_row_index();
    $newsRowClass = $currentRowIndex == $count ? 'last-position' : 'normal-position';
}

// Check for personalisation..
$pPostCats = array();
if(isset($_COOKIE['nescol_postCats']) && get_field('activate_personalisation_pins', 'option')){
    $pPostCats = $_COOKIE['nescol_postCats'];
    $pPostCats = json_decode(html_entity_decode(stripslashes ($pPostCats)));
}


$newsOverrideIDs = get_sub_field('news_swiper_overrides');
$overrideClass = get_sub_field('news_swiper_overrides') ? 'news-override' : "";
$args = [
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => 10,
    'post__in' => $newsOverrideIDs
];

if (count($pPostCats)>0){
    $args = [
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => 10,
        'post__in' => $newsOverrideIDs,
        'tax_query' => array(
            array(
                'taxonomy' => 'news-type',   // taxonomy name
                'field' => 'term_id',           // term_id, slug or name
                'terms' => $pPostCats,                  // term id, term slug or term name
            )
        )
    ];
}

$news = new WP_Query( $args ); ?>
<div class="<?= $newsRowClass; ?> custom-front-news <?= $overrideClass; ?>">
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-cyan-long.svg'); ?>
    <section class="posts-carousel">
        <div class="container">

            <?php if(get_field('news_carousel_title')) {
                $title = get_field('news_carousel_title') ?: '';
            } else {
                $title = get_sub_field('news_carousel_title') ?: '';
            }
            if($title !== '') { ?>
                <h2>
                    <?php if (count($pPostCats)>0){
                        echo $title;
                    }else{
                        echo 'Latest News';
                    }
                    ?>
                    <a class="heading-link" href="/news/">View more news articles</a>
                </h2>
            <?php } ?>

            <div class="custom-swiper-controls">
                <div class="news-swiper-prev custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                <div class="news-swiper-next custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
            </div>

            <div class="swiper-container news-swiper">
                <div class="swiper-wrapper" role="feed">
                    <?php while ($news->have_posts()) {
                        $news->the_post();
                        $categories = get_the_terms(get_the_id(), 'news-type');
                        $image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
                        ?>
                        <article class="swiper-slide">
                            <div class="news-item">
                                <a href="<?php the_permalink(); ?>" aria-label="Open <?= get_the_title(); ?> Article">
                                    <div class="image-area <?php if(get_the_post_thumbnail_url() == '') { echo 'no-post-thumbnail'; } ?>">
                                        <?= get_template_part('templates/pins/pin-post'); ?>
                                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                    </div>
                                </a>
                                <div class="content-area">
                                    <?php if($categories) { ?>
                                        <ul class="categories">
                                            <?php foreach($categories as $cat) {
                                                $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                                <li data-pin-cat="<?= $cat->term_id;?>"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                    <h3><a href="<?php the_permalink(); ?>" aria-label="Open <?= get_the_title(); ?> Article"><?php the_title(); ?></a></h3>
                                </div>
                            </div>
                        </article>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </section>
</div>
