<?php
$modeOfStudy = get_the_terms(get_the_id(), 'mode-of-study');

if($modeOfStudy) {
    $modeOfStudy = $modeOfStudy[0]->slug;
    $modeOfStudyApplicationsTitleOverride = get_field($modeOfStudy . '_application_title', 'option');
    $modeOfStudyApplicationsDescriptionOverride = get_field($modeOfStudy . '_application_description', 'option');

    if($modeOfStudyApplicationsTitleOverride) {
        $applicationsTitle = $modeOfStudyApplicationsTitleOverride;
    } else{
        $applicationsTitle = get_field('applications_title_override') ? get_field('applications_title_override') : get_field('default_applications_title', 'option');
    }

    if($modeOfStudyApplicationsDescriptionOverride){
        $applicationDescription = $modeOfStudyApplicationsDescriptionOverride;
    } else {
        $applicationDescription = get_field('applications_description_override') ? get_field('applications_description_override') : get_field('default_applications_description', 'option');
    }

    $data = \Blue2\Scruffy\Controllers\CourseController::getApplicationData($modeOfStudy);
    $sortedData = \Blue2\Scruffy\Controllers\CourseController::sortApplicationData($data); ?>
    <div class="applications" id="applications-location">
        <div class="container">
            <div class="course-section-introduction">
                <h2><?= $applicationsTitle; ?></h2>
                <?= $applicationDescription; ?>
            </div>
            <?php \Blue2\Scruffy\Controllers\CourseController::outputApplicationInstances($sortedData); ?>
        </div>
    </div>
<?php }
