<?php
$categories = get_the_terms(get_the_id(), 'news-type');
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-featured-image') : get_field('default_image_logo', 'option');
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
$excludedEvents = \Blue2\Scruffy\Controllers\EventController::getExcludedEvents();
$eventArgs = [
    'post_type' => 'event',
    'posts_per_page' => 3,
    'post_status' => 'publish',
    'post__not_in' => $excludedEvents
];
$events = new WP_query($eventArgs);
?>
<div class="featured-area news-section">
    <div class="col-lg-12">
        <div class="row">
            <div class="col-xl-12 col-xxl-9">
                <h2 class="events-title d-block d-xl-none">News</h2>
                <article class="featured-article">
                    <div class="featured-image-holder <?= $imageClass; ?>">
                        <a href="<?php the_permalink(); ?>">
                            <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                        </a>
                    </div>
                    <?php if($categories) { ?>
                        <ul class="categories">
                            <?php foreach($categories as $cat) {
                                $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                <li><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                    <h2 class="date"><?= get_the_date('d.m.y') ?></h2>
                </article>
            </div>
            <div class="col-xl-12 col-xxl-3">
                <?php if($events->have_posts()) { ?>
                    <div class="featured-events">
                        <h2 class="events-title">Upcoming Events <a href="/events/" class="view-all">View All</a></h2>
                        <div class="swiper-container blog-events-swiper">
                            <div class="swiper-wrapper event-feed" role="feed">
                                <?php while ($events->have_posts()) {
                                    $events->the_post();
                                    $eventImage = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
                                    $eventClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
                                    ?>
                                    <article class="swiper-slide">
                                        <div class="card">
                                            <div class="featured-event">
                                                <div class="image-holder <?= $eventClass; ?>">
                                                    <?= get_template_part('templates/pins/pin-post'); ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <img src="<?= $eventImage; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                                                    </a>
                                                </div>
                                                <div class="card-body">
                                                    <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                    <?php Blue2\Scruffy\Controllers\EventController::outputEventEntries(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </article>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>


