<?php $rowCount = count(get_field('featured_blocks'));
if($rowCount == 1){
    $colClass = 'col-lg-12';
} elseif ($rowCount == 2) {
    $colClass = 'col-lg-6';
} elseif($rowCount == 3) {
    $colClass = 'col-lg-4';
}
?>
<div class="home-block">
    <div class="container">
        <?php if(get_field('featured_content_title')) { ?>
            <h2><?php the_field('featured_content_title') ?></h2>
        <?php } if(get_field('featured_introduction')) { ?>
            <div class="featured-intro"><?php the_field('featured_introduction') ?></div>
        <?php }
        if( have_rows('featured_blocks') ) { ?>
            <div class="row">
                <?php while (have_rows('featured_blocks')) {
                    the_row();
                    $link = get_sub_field('featured_link');
                    $image = get_sub_field('featured_image');
                    $cardImage = $image['url'] ? : get_field('default_image_logo', 'option');
                    $cardImageClass = get_sub_field('featured_image') ? 'featured-img-holder' : "default-img-holder";
                    ?>
                    <div class="vertical-card d-flex align-items-stretch card-item-custom <?= $colClass; ?>">
                        <div class="card">
                            <div class="embed-responsive embed-responsive-16by9 img-holder <?= $cardImageClass; ?>">
                                <a href="<?= $link['url']; ?>">
                                    <img src="<?= $cardImage; ?>" class="card-img-top embed-responsive-item" alt="<?php get_sub_field('featured_title'); ?>">
                                </a>
                            </div>
                            <div class="card-body">
                                <?php if (get_sub_field('featured_title')) { ?>
                                    <h3 class="card-title"><?php the_sub_field('featured_title'); ?></h3><?php } ?>
                                <?php if (get_sub_field('featured_content_snippet')) { ?>
                                    <p class="card-text"><?php the_sub_field('featured_content_snippet'); ?></p><?php } ?>
                                <?php if ($link) { ?>
                                    <div class="text-cta">
                                        <a href="<?= $link['url']; ?>"><?= $link['title']; ?><i class="fal fa-long-arrow-right"></i></a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>