<div class="flexible-layout-block category-selector-block">
    <?php $categories = Blue2\Scruffy\Site::getAllNonParentCategories(); ?>
    <div class="introduction-block">
        <?= @file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-right-green.svg'); ?>
        <div class="container">
            <div class="row">
                <div class="offset-xxl-2 col-xxl-7">
                    <h2><?php the_sub_field('introduction_title'); ?></h2>
                </div>
            </div>
            <div class="row">
                <div class="offset-xxl-2 col-xxl-8">
                    <div class="all-category-listing">
                        <button class="interested-in" aria-label="Open Course Categories">I'm interested in <span class="highlight"><?php the_sub_field('featured_interest'); ?></span><i class="fal fa-chevron-down"></i></button>
                        <div class="super-categories" aria-live="assertive">
                            <div class="row row-eq-height">
                                <?php foreach($categories as $key => $category){
                                    $categoryParent = get_term($category->parent);
                                    $categoryColour = get_field('category_colour', 'category_' . $categoryParent->term_id) ? : "#623C7C";
                                    $categoryImage = get_field('category_image', 'category_' . $category->term_id) ? : get_field('default_image_logo', 'option');
                                    $partTimeCount = Blue2\Scruffy\Site::getCourseCount('part-time', $category->slug);
                                    $fullTimeCount = Blue2\Scruffy\Site::getCourseCount('full-time', $category->slug);
                                    ?>
                                    <div class="col-md-6 col-xl-4 super-col">
                                        <div class="super-category-item">
                                            <span class="parent-category" style="background-color:<?= $categoryColour; ?>"><?= $categoryParent->name; ?></span>
                                            <h3><a href="<?= "/courses/?interests=" . $category->slug; ?>"><?= $category->name; ?></a></h3>
                                            <div class="by-interest-bottom">
                                                <div class="row no-gutters">
                                                    <div class="col-6 count-col">
                                                        <?php if($fullTimeCount > 0) { ?>
                                                            <div class="course-count"><?= $fullTimeCount; ?></div>
                                                            <a href="<?= "/courses/?interests=" . $category->slug  . "&mode-of-study=full-time"?>" aria-label="<?= 'View full-time ' . $category->name . ' courses'; ?>">Full-time Courses</a>
                                                        <?php } ?>
                                                    </div>
                                                    <div class="col-6 count-col">
                                                        <?php if($partTimeCount > 0) { ?>
                                                            <div class="course-count"><?= $partTimeCount; ?></div>
                                                            <a href="<?= "/courses/?interests=" . $category->slug  . "&mode-of-study=part-time"?>" aria-label="<?= 'View part-time ' . $category->name . ' courses'; ?>">Part-time Courses</a>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="col-md-6 col-xl-4 super-col">
                                    <div class="super-category-item">
                                        <span class="parent-category" style="background-color:#623C7C">NESCol</span>
                                        <h3><a href="<?= "/courses/?mode-of-study=part-time"; ?>">Part Time Courses</a></h3>
                                    </div>
                                </div>
                                <div class="col-md-6 col-xl-4 super-col">
                                    <div class="super-category-item">
                                        <span class="parent-category" style="background-color:#623C7C">NESCol</span>
                                        <h3><a href="<?= "/courses/?mode-of-study=training-for-business"; ?>">Training for Business Courses</a></h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if( have_rows('introduction_ctas') ) { ?>
                            <div class="intro-ctas">
                                <ul role="list">
                                    <?php while ( have_rows('introduction_ctas') ) {
                                        the_row();
                                        $link = get_sub_field('cta'); ?>
                                        <li role="listitem"><a href="<?= $link['url']; ?>" class=""><?= $link['title']; ?></a><i class="fal fa-chevron-right"></i></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>