<?php


namespace Blue2\Scruffy\Controllers;


class DashboardController
{
    /* @var ImportController */
    private $importer;
    /* @var UniteController */
    private $unite;

    public function __construct()
    {
        add_action('wp_dashboard_setup', [$this, 'addWidget']);
        add_action('admin_enqueue_scripts', [$this, 'addScripts']);
        add_action('init', [$this, 'initialise'], 11);
        add_action('rest_api_init', [$this, "setupEndpoints"]);

        $this->importer = new ImportController();
        $this->unite = new UniteController();
    }

    public function addWidget()
    {
        wp_add_dashboard_widget('runImportWidget', 'Start Import', [$this, "displayWidget"]);
    }

    public function addScripts()
    {
        wp_enqueue_media();
    }

    public function displayWidget()
    {
        $themeDirectory = trailingslashit(plugin_dir_path(__FILE__));
        include $themeDirectory . '../Templates/ImportWidget.php';

    }

    public function initialise()
    {
        if ($this->isImportRequestSubmitted()) {
            $this->importer->import($_POST['importFile']);
            die();
        }
    }

    private function isImportRequestSubmitted()
    {
        return isset($_POST['runImport']);
    }

    public function setupEndpoints()
    {
        $routes = [
            '/import/' => 'startUniteFullTimeImport',
            '/importPartTime/' => 'startUnitePartTimeImport',
        ];

        foreach ($routes as $route => $callback) {
            $this->registerRoute($route, $callback);
        }
    }

    private function registerRoute($route, $callback)
    {
        register_rest_route(
            'api/v1',
            $route,
            [
                'methods' => 'GET, POST',
                'callback' => [$this->unite, $callback],
            ]
        );
    }


}
