const contact = () => {
    $('.trigger-opening-hours').on('click', function() {
        $(this).next('.opening-hours')
            .slideToggle(function() {
                $(this).parent()
                    .find('.trigger-opening-hours')
                    .toggleClass('triggered', $(this).is(':visible'));
            });
    });

    //Google Maps
    const google = window.google;
    const locations = $('#map').data('locations');
    let mapLng = $('#map').data('map-center-lng');
    let mapLat = $('#map').data('map-center-lat');
    let mapZoom = $('#map').data('map-zoom');

    if (mapLng !== '' && mapLat !== '') {
        mapLng = $('#map').data('map-center-lng');
        mapLat = $('#map').data('map-center-lat');
    } else {
        mapLng = 0;
        mapLat = 0;
        $('.map-section').addClass('inactive');
    }
    if (mapZoom === '') {
        mapZoom = 9;
    }

    if ($(window).width() < 992) {
        mapZoom = 5;
    }
    const mapCenter = { lat: mapLat, lng: mapLng };
    const map = new google.maps.Map(document.getElementById('map'), {
        zoom: mapZoom,
        center: mapCenter,
        gestureHandling: 'greedy',
        scrollwheel: false,
        streetViewControl: false,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL,
            position: google.maps.ControlPosition.TOP_RIGHT
        },
    });


    const infowindow = new google.maps.InfoWindow;

    let marker;
    let i;

    for (i = 0; i < locations.length; i++) {
        if (locations[i][1] !== '' && locations[i][1] !== '') {
            marker = new google.maps.Marker({
                position : new google.maps.LatLng(locations[i][2], locations[i][1]),
                icon: 'https://d1ssu070pg2v9i.cloudfront.net/pex/nescol/2019/09/10093406/nescol-marker.png',
                map,
                animation: google.maps.Animation.DROP,
            });
        }

        google.maps.event.addListener(marker, 'click', (function(marker, i) {
            return function() {
                if (locations[i][3] === '') {
                    infowindow.setContent(locations[i][0]);
                } else {
                    infowindow.setContent(`<a href='${locations[i][3]}'>${locations[i][0]}</a>`);
                }
                infowindow.open(map, marker);
            };
        }(marker, i)));
    }
};

export default contact;
