<?php
$subjects = get_the_terms(get_the_id(), 'category');
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : get_field('default_image_logo', 'option');
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
?>

<?= get_template_part('templates/sections/news-hero'); ?>

<main class="custom-news-single custom-story-single news-section" role="main">
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-right-yellow.svg'); ?>
    <div class="container">
        <div class="row">
            <div class="offset-xl-2 col-xl-8">
                <div class="single-feature-image image-holder <?= $imageClass ?>">
                    <?php if($image) { ?>
                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                    <?php } ?>
                </div>
                <div class="single-news-content">
                    <div class="title-section text-center">
                        <i class="fas fa-chevron-double-right fa-5x"></i>
                        <i class="fas fa-chevron-double-down fa-5x"></i>
                        <h1><?php the_title(); ?></h1>
                        <?php if($subjects) { ?><h2 class="subject"><?= $subjects[0]->name; ?></h2><?php } ?>
                    </div>
                    <div class="story-quote text-center">
                        <?php the_field('story_quote'); ?>
                    </div>
                    <?php the_content(); ?>
                    <div class="view-more-stories view-more text-center">
                        <a href="/stories/">View More Stories</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
