<?php get_header(); ?>

<?= get_template_part('templates/sections/default-hero');

global $wpdb;
$searchQuery = get_search_query();
$courseIds = \Blue2\Scruffy\Controllers\CourseController::customCourseSearch($searchQuery);
$swiperCount = 0;
?>
<div class="custom-search-layout">
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-left-cyan-vertical.svg'); ?>
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-yellow.svg'); ?>
    <?php if ( have_posts() || $courseIds) {
        $pageIds = [];
        $eventIds = [];
        $newsIds = [];
        $storyIds = [];
        while ( have_posts() ) {
            the_post();
            if(get_post_type() == 'post'){
                array_push($newsIds, get_the_id());
            } elseif(get_post_type() == 'course') {
                continue;
            } elseif(get_post_type() == 'event') {
                array_push($eventIds, get_the_id());
            } elseif(get_post_type() == 'story') {
                array_push($storyIds, get_the_id());
            } else {
                array_push($pageIds, get_the_id());
            }
        } wp_reset_postdata();
        ?>
        <div class="container">
            <div class="scroll-options">
                <ul role="list">
                    <?php
                    if($courseIds) { ?>
                        <li role="listitem"><a href="#related-courses-section">Courses (<?= count($courseIds) ?>) </a></li>
                    <?php }
                    if($pageIds) { ?>
                        <li role="listitem"><a href="#related-pages-section">Pages (<?= count($pageIds) ?>)</a></li>
                    <?php }
                    if($newsIds) { ?>
                        <li role="listitem"><a href="#related-news-section">News (<?= count($newsIds) ?>)</a></li>
                    <?php }
                    if($eventIds) { ?>
                        <li role="listitem"><a href="#related-events-section">Events (<?= count($eventIds) ?>)</a></li>
                    <?php }
                    if($storyIds) { ?>
                        <li role="listitem"><a href="#related-events-section">Stories (<?= count($storyIds) ?>)</a></li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <div class="search-output">
            <div class="container">
                <?php
                if($courseIds) {
                    $swiperCount++;
                    $courseCount = count($courseIds);
                    $showingMessage = $courseCount < 10 ? $courseCount : 10;
                    $args = [
                        'post_type' => 'course',
                        'post__in' => $courseIds,
                        'posts_per_page' => 10,
                        'orderby' => 'title',
                        'order' => 'ASC'
                    ];
                    $courses = get_posts($args); ?>
                    <section class="result-section results-courses" id="related-courses-section">
                        <h2>Courses (<?= "Showing " . $showingMessage . " of " . count($courseIds) . ' Results'; ?>) <?php if($courseCount > 10) { ?> <a href="/courses/?keyword=<?= $searchQuery; ?>"><span class="remaining-results"><span class="separator"> - </span>Click here to show all results</span></a> <?php } ?></h2>

                        <div class="custom-swiper-controls">
                            <div class="<?= "search-swiper-prev-" . $swiperCount; ?> custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                            <div class="<?= "search-swiper-next-" . $swiperCount; ?> custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                        </div>

                        <div class="swiper-container search-swiper <?= 'search-swiper-' . $swiperCount; ?>">
                            <div class="swiper-wrapper" role="feed">
                                <?php foreach($courses as $course) {
                                    $colour = Blue2\Scruffy\Site::getParentCategoryColour($course->ID);
                                    $parentCategoryName = Blue2\Scruffy\Site::getParentCategory($course->ID);
                                    $courseCategory = get_the_category($course->ID);
                                    $image = \Blue2\Scruffy\Controllers\CourseController::getCourseImage($course->ID, 'news-image');
                                    $modesOfStudy = \Blue2\Scruffy\Controllers\CourseController::getCourseModesOfStudy($course->ID);
                                    $levels = get_the_terms($course->ID, 'level');
                                    if($levels) {
                                        $qualificationOutput = get_field('qualification_type', $course->ID) . ' (' . $levels[0]->name . ')';
                                    } else{
                                        $qualificationOutput = get_field('qualification_type', $course->ID);
                                    } ?>
                                    <article class="swiper-slide search-slide">
                                        <?php $imageClass = (get_the_post_thumbnail_url($course->ID) == '' && $image['image_format'] == 'cat-not-set') ? 'no-post-thumbnail' : 'image-present'; ?>
                                        <div class="search-item">
                                            <a href="<?php the_permalink($course->ID); ?>" aria-label="Open <?= $course->post_title; ?> Article">
                                                <div class="image-area <?= $imageClass; ?>">
                                                    <img src="<?= $image['image_url']; ?>" alt="<?= $course->post_title; ?>">
                                                </div>
                                            </a>
                                            <div class="content-area">
                                                <?php if($parentCategoryName) { ?><span class="parent-category" style="background-color:<?= $colour; ?>"><?= $parentCategoryName; ?></span><?php } ?>
                                                <?php if(has_tag('coming-soon', $course->ID)) { ?><span class="coming-soon" style="border:1px solid <?= $colour; ?>; color:<?= $colour; ?>">Coming soon</span><?php } ?>
                                                <?php if($modesOfStudy) { ?><h4 class="search-mode"><i class="fas fa-books course-svg" style="color:<?= $colour; ?>"></i><span class="highlight">Mode of Study</span>: <?= implode(', ', $modesOfStudy); ?></h4><?php } ?>
                                                <?php if($qualificationOutput) { ?><h4 class="search-mode"><i class="fas fa-graduation-cap course-svg" style="color:<?= $colour; ?>"></i><span class="highlight">Qualification</span>: <?= $qualificationOutput; ?></h4><?php } ?>
                                                <h3><a href="<?php the_permalink($course->ID); ?>" aria-label="Open <?= $course->post_title; ?> Article"><?= $course->post_title; ?></a></h3>
                                            </div>
                                        </div>
                                    </article>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                    </section>
                <?php } if($pageIds) {
                    $swiperCount++;
                    $args = [
                        'post_type' => 'page',
                        'post__in' => $pageIds,
                        'posts_per_page' => 15,
                        'orderby' => 'title',
                        'order' => 'ASC'
                    ];
                    $pages = get_posts($args); ?>
                    <section class="result-section results-pages" id="related-pages-section">
                        <h2>Pages (<?= count($pageIds) . ' Results'; ?>)</h2>
                        <div class="custom-swiper-controls">
                            <div class="<?= "search-swiper-prev-" . $swiperCount; ?> custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                            <div class="<?= "search-swiper-next-" . $swiperCount; ?> custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                        </div>
                        <div class="swiper-container search-swiper <?= 'search-swiper-' . $swiperCount; ?>">
                            <div class="swiper-wrapper" role="feed">
                                <?php foreach($pages as $page) {
                                    $image = get_the_post_thumbnail_url($page->ID, 'news-image') ?: get_field('default_image_logo', 'option'); ?>
                                    <article class="swiper-slide search-slide">
                                        <div class="search-item">
                                            <a href="<?php the_permalink($page->ID); ?>" aria-label="Open <?= $page->post_title; ?> Article">
                                                <div class="image-area <?php if(get_the_post_thumbnail_url($page->ID) == '') { echo 'no-post-thumbnail'; } ?>">
                                                    <img src="<?= $image; ?>" alt="<?= $page->post_title; ?>">
                                                </div>
                                            </a>
                                            <div class="content-area">
                                                <h3><a href="<?php the_permalink($page->ID); ?>" aria-label="Open <?= $page->post_title; ?> Article"><?= $page->post_title; ?></a></h3>
                                            </div>
                                        </div>
                                    </article>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </section>
                <?php }
                if($storyIds) {
                    $swiperCount++;
                    $args = [
                        'post_type' => 'story',
                        'post__in' => $storyIds,
                        'posts_per_page' => 15,
                        'orderby' => 'title',
                        'order' => 'ASC'
                    ];
                    $stories = get_posts($args); ?>
                    <section class="result-section results-pages" id="related-pages-section">
                        <h2>Stories (<?= count($storyIds) . ' Results'; ?>)</h2>
                        <div class="custom-swiper-controls">
                            <div class="<?= "search-swiper-prev-" . $swiperCount; ?> custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                            <div class="<?= "search-swiper-next-" . $swiperCount; ?> custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                        </div>
                        <div class="swiper-container search-swiper <?= 'search-swiper-' . $swiperCount; ?>">
                            <div class="swiper-wrapper" role="feed">
                                <?php foreach($stories as $story) {
                                    $image = get_the_post_thumbnail_url($story->ID, 'news-image') ?: get_field('default_image_logo', 'option'); ?>
                                    <article class="swiper-slide search-slide">
                                        <div class="search-item">
                                            <a href="<?php the_permalink($story->ID); ?>" aria-label="Open <?= $story->post_title; ?> Article">
                                                <div class="image-area <?php if(get_the_post_thumbnail_url($story->ID) == '') { echo 'no-post-thumbnail'; } ?>">
                                                    <img src="<?= $image; ?>" alt="<?= $story->post_title; ?>">
                                                </div>
                                            </a>
                                            <div class="content-area">
                                                <h3><a href="<?php the_permalink($story->ID); ?>" aria-label="Open Story"><?= $story->post_title; ?></a></h3>
                                            </div>
                                        </div>
                                    </article>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </section>
                <?php }
                if($newsIds) {
                    $swiperCount++;
                    $args = [
                        'post_type' => 'post',
                        'post__in' => $newsIds,
                        'posts_per_page' => 15,
                        'orderby' => 'title',
                        'order' => 'ASC'
                    ];
                    $news = get_posts($args); ?>
                    <section class="result-section results-posts" id="related-news-section">
                        <h2>News (<?= count($newsIds) . ' Results'; ?>)</h2>
                        <div class="custom-swiper-controls">
                            <div class="<?= "search-swiper-prev-" . $swiperCount; ?> custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                            <div class="<?= "search-swiper-next-" . $swiperCount; ?> custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                        </div>
                        <div class="swiper-container search-swiper <?= 'search-swiper-' . $swiperCount; ?>">
                            <div class="swiper-wrapper" role="feed">
                                <?php foreach($news as $newsItem) {
                                    $categories = get_the_terms($newsItem->ID, 'news-type');
                                    $image = get_the_post_thumbnail_url($newsItem->ID, 'news-image') ?: get_field('default_image_logo', 'option');
                                    ?>
                                    <article class="swiper-slide search-slide">
                                        <div class="search-item">
                                            <a href="<?php the_permalink($newsItem->ID); ?>" aria-label="Open <?= $newsItem->post_title; ?> Article">
                                                <div class="image-area <?php if(get_the_post_thumbnail_url($newsItem->ID) == '') { echo 'no-post-thumbnail'; } ?>">
                                                    <img src="<?= $image; ?>" alt="<?= $newsItem->post_title; ?>">
                                                </div>
                                            </a>
                                            <div class="content-area">
                                                <?php if($categories) { ?>
                                                    <ul class="categories" role="list">
                                                        <?php foreach($categories as $cat) {
                                                            $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                                            <li role="listitem"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                                                        <?php } ?>
                                                    </ul>
                                                <?php } ?>
                                                <h3><a href="<?php the_permalink($newsItem->ID); ?>" aria-label="Open <?= $newsItem->post_title; ?> Article"><?= $newsItem->post_title; ?></a></h3>
                                            </div>
                                        </div>
                                    </article>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </section>
                <?php }   if($eventIds) {
                    $swiperCount++;
                    $args = [
                        'post_type' => 'event',
                        'post__in' => $eventIds,
                        'posts_per_page' => 15,
                        'orderby' => 'title',
                        'order' => 'ASC'
                    ];
                    $events = get_posts($args); ?>
                    <section class="result-section results-events" id="related-events-section">
                        <h2>Events (<?= count($eventIds) . ' Results'; ?>)</h2>
                        <div class="custom-swiper-controls">
                            <div class="<?= "search-swiper-prev-" . $swiperCount; ?> custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                            <div class="<?= "search-swiper-next-" . $swiperCount; ?> custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                        </div>
                        <div class="swiper-container search-swiper <?= 'search-swiper-' . $swiperCount; ?>">
                            <div class="swiper-wrapper" role="feed">
                                <?php foreach($events as $event) {
                                    $image = get_the_post_thumbnail_url($event->ID, 'news-image') ?: get_field('default_image_logo', 'option');
                                    ?>
                                    <article class="swiper-slide search-slide">
                                        <div class="search-item">
                                            <a href="<?php the_permalink($event->ID); ?>" aria-label="Open <?= $event->post_title; ?> Article">
                                                <div class="image-area <?php if(get_the_post_thumbnail_url($event->ID) == '') { echo 'no-post-thumbnail'; } ?>">
                                                    <img src="<?= $image; ?>" alt="<?= $event->post_title; ?>">
                                                </div>
                                            </a>
                                            <div class="content-area">
                                                <h3><a href="<?php the_permalink($event->ID); ?>" aria-label="Open <?= $event->post_title; ?> Article"><?= $event->post_title; ?></a></h3>
                                                <?php if (have_rows('event_dates', $event->ID)) { ?>
                                                    <ul class="event-lists" role="list">
                                                        <li>
                                                            <span class="fa-stack">
                                                              <i class="fas fa-circle fa-stack-2x"></i>
                                                              <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                                                            </span>
                                                        </li>
                                                        <?php if (have_rows('event_dates', $event->ID)) {
                                                            if(count(get_field('event_dates', $event->ID)) > 1) { ?>
                                                                <li role="listitem">Various Dates</li>
                                                            <?php }  else { ?>
                                                                <?php while (have_rows('event_dates', $event->ID)) {
                                                                    the_row(); ?>
                                                                    <li role="listitem"><?php the_sub_field('event_date', $event->ID); ?></li>
                                                                <?php }
                                                            }?>
                                                        <?php } ?>
                                                    </ul>
                                                <?php }
                                                $locations = get_field('related_locations', $event->ID);
                                                if( $locations ){ ?>
                                                    <ul class="event-lists" role="list">
                                                        <li>
                                                            <span class="fa-stack">
                                                              <i class="fas fa-circle fa-stack-2x"></i>
                                                              <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                                                            </span>
                                                        </li>
                                                        <?php
                                                        if(count($locations) == 1) {
                                                            foreach ($locations as $post) { ?>
                                                                <?php setup_postdata($post); ?>
                                                                <li role="list-item"><?php the_title(); ?></li>
                                                            <?php }
                                                        }
                                                        else { ?>
                                                            <li role="list-item">Various Campuses</li>
                                                        <?php } ?>
                                                    </ul>
                                                    <?php wp_reset_postdata(); ?>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </article>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </section>
                <?php } ?>
            </div>
        </div>
    <?php } else { ?>
        <div class="container">
            <div class="no-results-message">
                <?php the_field('no_search_results_message', 'option'); ?>
            </div>
        </div>
    <?php } ?>
</div>
<?php get_footer(); ?>
