<?php

$cardsPerRow = get_sub_field('number_of_cards_per_row');
$cardLayout = (get_sub_field('card_layout') == 'container-width') ? 'container' : 'container-fluid';
$cardDirection = get_sub_field('card_direction');
$cardType = get_sub_field('card_type');

switch ($cardsPerRow) {
    case '2':
        $cardCols = 'col-lg-6';
        break;
    case '3':
        $cardCols = 'col-lg-6 col-xl-4';
        break;
    case '4':
        $cardCols = 'col-lg-6 col-xl-3';
        break;
}
?>
<div class="flexible-layout-block cards-block">
    <div class="<?= $cardLayout; ?>">
        <div class="row">
            <?php
            if ($cardType == 'custom-cards') {
                if (have_rows('cards')) {
                    while (have_rows('cards')) {
                        the_row();
                        $cardImage = get_sub_field('card_image') ? : get_field('default_image_logo', 'option');
                        $cardImageClass = get_sub_field('card_image') ? 'featured-img-holder' : "default-img-holder";
                        $cardTitle = get_sub_field('card_title');
                        $cardContent = get_sub_field('card_content');
                        $cardCTA = get_sub_field('card_cta');

                        if ($cardDirection == 'vertical') { ?>
                            <div class="vertical-card d-flex align-items-stretch card-item-custom <?= $cardCols; ?>">
                                <div class="card">
                                    <div class="embed-responsive embed-responsive-16by9 img-holder <?= $cardImageClass; ?>">
                                        <a href="<?= $cardCTA['url']; ?>">
                                            <img src="<?= $cardImage ?>" class="card-img-top embed-responsive-item" alt="<?= $cardTitle; ?>">
                                        </a>
                                    </div>
                                    <div class="card-body">
                                        <?php if ($cardTitle) { ?>
                                            <h3 class="card-title"><?= $cardTitle; ?></h3><?php } ?>
                                        <?php if ($cardContent) { ?>
                                            <p class="card-text"><?= $cardContent; ?></p><?php } ?>
                                        <?php if ($cardCTA) { ?>
                                            <div class="text-cta">
                                                <a href="<?= $cardCTA['url']; ?>" target="<?= $cardCTA['target']; ?>"><span class="underline"><?= $cardCTA['title']; ?></span><i class="fal fa-long-arrow-right"></i></a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="horizontal-card d-flex align-items-stretch card-item-custom <?= $cardCols; ?>">
                                <div class="card">
                                    <div class="row no-gutters h-100">
                                        <div class="col-lg-6">
                                            <div class="embed-responsive embed-responsive-16by9 img-holder <?= $cardImageClass; ?>">
                                                <a href="<?= $cardCTA['url'] ?? '#'; ?>">
                                                    <img src="<?= $cardImage ?>" class="card-img embed-responsive-item" alt="<?= $cardTitle; ?>">
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="card-body">
                                                <?php if ($cardTitle) { ?>
                                                    <h3 class="card-title"><?= $cardTitle; ?></h3><?php } ?>
                                                <?php if ($cardContent) { ?>
                                                    <p class="card-text"><?= $cardContent; ?></p><?php } ?>
                                                <?php if ($cardCTA) { ?>
                                                    <div class="text-cta">
                                                        <a href="<?= $cardCTA['url']; ?>" target="<?= $cardCTA['target']; ?>"><span class="underline"><?= $cardCTA['title']; ?></span><i class="fal fa-long-arrow-right"></i></a>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    }
                }
            } else {
                $relationshipCards = get_sub_field('relationship_cards');
                if ($relationshipCards) {
                    foreach ($relationshipCards as $post) {
                        setup_postdata($post);
                        $cardImage = get_the_post_thumbnail_url() ? : get_field('default_image_logo', 'option');
                        $cardImageClass = get_the_post_thumbnail_url() ? 'featured-img-holder' : "default-img-holder";
                        $cardTitle = get_the_title();
                        $cardContent = wp_trim_words(get_the_excerpt(), '30');
                        $cardCTA = ['url' => get_the_permalink(), 'title' => 'Read More'];
                        if ($cardDirection == 'vertical') { ?>
                            <div class="vertical-card d-flex align-items-stretch card-item-custom <?= $cardCols; ?>">
                                <div class="card">
                                    <div class="embed-responsive embed-responsive-16by9 img-holder <?= $cardImageClass; ?>">
                                        <img src="<?= $cardImage ?>" class="card-img-top embed-responsive-item" alt="<?= $cardTitle; ?>">
                                    </div>
                                    <div class="card-body">
                                        <?php if ($cardTitle) { ?>
                                            <h3 class="card-title"><?= $cardTitle; ?></h3><?php } ?>
                                        <?php if ($cardContent) { ?>
                                            <p class="card-text"><?= $cardContent; ?></p><?php } ?>
                                        <?php if ($cardCTA) { ?>
                                            <a href="<?= $cardCTA['url']; ?>" class="cta"><?= $cardCTA['title']; ?> <i class="fal fa-long-arrow-right"></i></a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } else {  ?>
                            <div class="horizontal-card d-flex align-items-stretch card-item-custom <?= $cardCols; ?>">
                                <div class="card">
                                    <div class="row no-gutters h-100">
                                        <div class="col-lg-6">
                                            <div class="embed-responsive embed-responsive-16by9 img-holder <?= $cardImageClass; ?>">
                                                <?php if ($cardTitle) { ?><img src="<?= $cardImage ?>" class="card-img embed-responsive-item" alt="<?= $cardTitle; ?>"><?php } ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="card-body">
                                                <?php if ($cardTitle) { ?>
                                                    <h3 class="card-title"><?= $cardTitle; ?></h3><?php }
                                                if ($cardContent) { ?>
                                                    <p class="card-text"><?= $cardContent; ?></p><?php }
                                                if ($cardCTA) { ?>
                                                    <a href="<?= $cardCTA['url']; ?>" class="cta"><?= $cardCTA['title']; ?> <i class="fal fa-long-arrow-right"></i></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>

                    <?php
                    }
                    wp_reset_postdata();
                }
            } ?>
        </div>
    </div>
</div>
