<?php

$categories = get_the_terms(get_the_id(), 'news-type');
$image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : get_field('default_image_logo', 'option');
$imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
$relatedIds = []
?>

<?= get_template_part('templates/sections/news-hero'); ?>

<main class="custom-news-single news-section" role="main">
    <div class="container">
        <div class="row">
            <div class="offset-xl-2 col-xl-8">
                <div class="single-feature-image image-holder <?= $imageClass ?>">
                    <?php if($image) { ?>
                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                    <?php } ?>
                </div>
                <ul class="categories">
                    <?php if($categories) {
                        foreach ($categories as $cat) {
                            array_push($relatedIds, $cat->term_id);
                            $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                            <li><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                        <?php }
                    }?>
                </ul>
                <div class="single-news-content">
                    <i class="fas fa-chevron-double-right fa-5x"></i>
                    <i class="fas fa-chevron-double-down fa-5x"></i>

                    <h1><?php the_title(); ?></h1>
                    <h2 class="date"><?= get_the_date() ?></h2>
                    <?php the_content(); ?>

                    <div class="view-more-stories view-more text-center">
                        <a href="/news/">View More News Articles</a>
                    </div>


                </div>
            </div>
        </div>
    </div>

    <?= get_template_part('templates/sections/post-gallery'); ?>


    <?php if($relatedIds) {
        $relatedArgs = [
            'post__not_in' => [get_the_id()],
            'post_type' => 'post',
            'posts_per_page' => 7,
            'tax_query' => [
                [
                    'taxonomy' => 'news-type',
                    'terms' => $relatedIds,
                ]
            ]
        ];
        $moreLikeThisCount = 0;
        $moreLikeThis = new WP_Query($relatedArgs);
        if ($moreLikeThis->have_posts()) { ?>
            <div class="more-articles">
                <div class="container">
                    <h2 class="more-title">More like this</h2>
                    <div class="row d-flex justify-content-center">
                        <?php while ($moreLikeThis->have_posts()) {
                            $moreLikeThis->the_post();
                            $moreLikeThisCount++;

                            if($moreLikeThisCount >= 1 && $moreLikeThisCount <= 3){
                                $moreClass = 'col-lg-6 col-xl-4';
                            } else{
                                $moreClass = 'col-lg-6 col-xl-3';
                            }

                            $categories = get_the_terms(get_the_id(), 'news-type');

                            $image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url(get_the_id(), 'news-image') : get_field('default_image_logo', 'option');
                            $imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
                            ?>

                            <div class="<?= $moreClass; ?> news-col news-section">
                                <div class="card">
                                    <article class="news-article">
                                        <div class="image-holder <?= $imageClass; ?>">
                                            <?= get_template_part('templates/pins/pin-post'); ?>
                                            <a href="<?php the_permalink(); ?>">
                                            <img src="<?= $image; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                                            </a>
                                        </div>
                                        <div class="card-body">
                                            <ul class="categories">
                                                <?php foreach($categories as $cat) {
                                                    $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                                    <li data-pin-cat="<?= $cat->term_id;?>"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                                                <?php } ?>
                                            </ul>
                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                            <h3 class="date"><?= get_the_date('d.m.y') ?></h3>
                                        </div>
                                    </article>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php }
    } ?>
</main>
