<?php

namespace Blue2\Scruffy\Controllers;

use Blue2\Scruffy\Site;

class EventController
{
    public static function getEventDates($outputType, $id = null)
    {
        $output = $outputType;
        if ($id){
            $eventDates = get_field('event_dates', $id);
        }else{
            $eventDates = get_field('event_dates');
        }
        //  var_dump($eventDates);
        if(!$eventDates){
            return;
        }
        if ($output == 'short') { ?>
            <ul class="event-lists" role="list">
                <li>
                <span class="fa-stack">
                  <i class="fas fa-circle fa-stack-2x"></i>
                  <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                </span>
                </li>
                <?php if (count($eventDates) > 1) { ?>
                    <li role="listitem">Various Dates</li>
                <?php } else { ?>
                    <?php
                    if ($id){
                        ?>
                        <li role="listitem"><?= $eventDates[0]['event_date']; ?></li>
                        <?php
                    }else{
                        while (have_rows('event_dates')) {
                            the_row(); ?>
                            <li role="listitem"><?php the_sub_field('event_date'); ?></li>
                        <?php }
                    }
                } ?>
            </ul>
        <?php } else { ?>
            <ul class="event-lists" role="list">
                <li>
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                    </span>
                </li>
                <?php if (have_rows('event_dates')) {
                    while (have_rows('event_dates')) {
                        the_row(); ?>
                        <li role="listitem"><?php the_sub_field('event_date'); ?></li>
                    <?php }
                } ?>
            </ul>
        <?php }
    }

    public static function getEventLocations($outputType, $id = null){
        $output = $outputType;
        $eventCount = 0;
        if ($id){
            $eventLocations = get_field('related_locations', $id);
            $externalLocation = get_field('external_event_location', $id);
        }else{
            $eventLocations = get_field('related_locations');
            $externalLocation = get_field('external_event_location');
        }

        if($eventLocations) {
            $eventCount = count($eventLocations);
        }

        if($externalLocation) {
            $eventCount++;
        }

        if(!$eventLocations && !$externalLocation){
            return;
        }

        if ($output == 'short') { ?>
            <ul class="event-lists" role="list">
                <li>
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                    </span>
                </li>
                <?php if ($eventCount > 1) { ?>
                    <li role="listitem">Various Campuses</li>
                <?php } else {
                    if($eventLocations) {
                        foreach ($eventLocations as $post) {
                            setup_postdata($post); ?>
                            <li role="listitem"><?= $post->post_title ?></li>
                        <?php }
                    } else {
                        echo $externalLocation;
                    }
                } ?>
            </ul>
        <?php } else { ?>
            <ul class="event-lists" role="list">
                <li>
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                    </span>
                </li>
                <?php
                if($eventLocations) {
                    foreach ($eventLocations as $post) { ?>
                        <?php setup_postdata($post); ?>
                        <li role="listitem"><?= $post->post_title ?></li>
                    <?php }
                }
                if($externalLocation) { ?>
                    <li><?= $externalLocation; ?></li>
                <?php } ?>
            </ul>
            <?php wp_reset_postdata(); ?>

        <?php }
    }

    public static function getEventTimes() {
        $eventDateTimes = [];
        if( have_rows('event_dates') ) {
            while (have_rows('event_dates')) {
                the_row();
                $eventDateTimes[] = ['date' => get_sub_field('event_date'), 'event_start_time' => get_sub_field('event_start_time'), 'event_end_time' => get_sub_field('event_end_time') ];
            }
        }

        if($eventDateTimes){ ?>
            <ul class="event-lists event-date-times" role="list">
                <li class="time-logo">
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas fal fa-clock fa-stack-1x fa-inverse"></i>
                    </span>
                </li>
                <?php foreach($eventDateTimes as $key => $value){
                    if($value['event_start_time'] !== '' && $value['event_end_time']) { ?>
                        <li><?= $value['date'] . ' (' . $value['event_start_time'] . ' - ' . $value['event_end_time'] . ')'; ?></li>
                    <?php }
                } ?>
            </ul>
        <?php }
    }

    public static function outputEventEntries() {
        $eventEntries = get_field('event_dates');
        if($eventEntries) {
            if (count($eventEntries) > 1) { ?>
                <ul class="event-lists" role="list">
                    <li>
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                        </span>
                    </li>
                    <li role="listitem">Various Dates/Locations</li>
                </ul>
            <?php } else { ?>
                <ul class="event-lists" role="list">
                    <li>
                        <span class="fa-stack">
                          <i class="fas fa-circle fa-stack-2x"></i>
                          <i class="fas far fa-calendar-alt fa-stack-1x fa-inverse"></i>
                        </span>
                    </li>
                    <li role="listitem"><?= $eventEntries[0]['event_date']; ?></li>
                </ul>

                <?php if($eventEntries[0]['event_location']) { ?>
                    <ul class="event-lists" role="list">
                        <li>
                    <span class="fa-stack">
                      <i class="fas fa-circle fa-stack-2x"></i>
                      <i class="fas fa-map-marker-alt fa-stack-1x fa-inverse"></i>
                    </span>
                        </li>
                        <li role="listitem"><?= $eventEntries[0]['event_location']; ?></li>
                    </ul>
                <?php }
            }
        }
    }

    public static function getExcludedEvents() {
        $excludedEvents = [];
        global $wpdb;
        $customSQL = "SELECT DISTINCT post_id, MAX(meta_value) AS maxDate FROM pex_nescol_postmeta 
                         INNER JOIN pex_nescol_posts ON (pex_nescol_postmeta.post_id = pex_nescol_posts.ID)
                        WHERE (pex_nescol_posts.post_password = '') 
                        AND (pex_nescol_posts.post_status = 'publish')
                        AND (pex_nescol_posts.post_type = 'event')
                        AND meta_key LIKE 'event_dates_%_event_date' GROUP BY post_id
                        HAVING maxDate < NOW()";
        $results = $wpdb->get_results($customSQL);
        foreach($results as $result) {
            array_push($excludedEvents, $result->post_id);
        }
        return $excludedEvents;
    }


}
