<?php $modesOfStudy = get_terms('mode-of-study');  ?>
<div class="courses-by by-campus">
    <?= get_template_part('templates/sections/courses-by/courses-by-hero'); ?>
    <?= get_template_part('templates/sections/courses-by/courses-by-filter'); ?>
    <main class="course-by-campus-output" role="main" id="main-area">
        <div class="container">
            <?php foreach($modesOfStudy as $mode) {
                $modeID = $mode->term_id;
                $modeImage = get_field('mode_of_study_image', 'mode-of-study_' . $modeID) ? : get_field('default_image_logo', 'option');
                $modeImageClass = get_field('mode_of_study_image', 'mode-of-study_' . $modeID) ? 'mode-image-set' : 'mode-image-unset';
                $modeTitle = $mode->name;
                ?>
                <div class="campus-item">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="image-area default-campus-image <?php if(!get_field('mode_of_study_image', 'mode-of-study_' . $modeID)) { echo 'default-campus-image'; } ?>">
                                <img src="<?= $modeImage; ?>" alt="<?= $modeTitle; ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="content-area">
                                <h2><?= $modeTitle; ?></h2>
                                <?= category_description($mode->term_id); ?>
                                <?php $modesOfStudyCoursesArgs = [
                                    'post_type' => 'course',
                                    'posts_per_page' => 20,
                                    'orderby' => 'rand',
                                    'tax_query' => [
                                        [
                                            'taxonomy' => 'mode-of-study',
                                            'terms' => $mode->slug,
                                            'field' => 'slug',
                                            'operator' => 'IN'
                                        ]
                                    ]
                                ];
                                $courses = new WP_Query($modesOfStudyCoursesArgs);
                                if ($courses->have_posts()) { ?>
                                    <p>A selection of <?= strtolower($modeTitle); ?> courses available at NESCol:</p>
                                    <ul class="course-list" role="list">
                                        <?php while ($courses->have_posts()) {
                                            $courses->the_post(); ?>
                                            <li role="listitem"><a href="<?php the_permalink(); ?>" aria-label="<?= 'View the ' . get_the_title() . ' course' ?>"><?php the_title(); ?></a></li>
                                        <?php }  ?>
                                    </ul>
                                <?php } wp_reset_postdata(); ?>

                                <div class="ctas">
                                    <a href="<?= "/courses/?mode-of-study=" . $mode->slug; ?>" aria-label="<?= "View all the " . $mode->name . "courses available at NESCol"; ?>">View All <?= $mode->name; ?> courses</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <?php } ?>
        </div>
    </main>
</div>
