<?php

$flexLayout = get_field('flexible_layout');
$newsRowClass = "";
if($flexLayout) {
    $count = count($flexLayout);
    $currentRowIndex = get_row_index();
    $newsRowClass = $currentRowIndex == $count ? 'last-position' : 'normal-position';
}
$storyIDs = [];
$categories = get_the_category();
if($categories) {
    $categoriesIDs = wp_list_pluck($categories, 'term_id');
    $storyInterests = new WP_Query(
        [
            'post_type' => 'story',
            'tax_query' => [
                [
                    'taxonomy' => 'category',
                    'field'    => 'id',
                    'terms'    => $categoriesIDs,
                ],
            ],
        ]
    );
    while ($storyInterests->have_posts()) {
        $storyInterests->the_post();
        array_push($storyIDs, get_the_id());
    }
}

if(is_singular('course')) {
    $storyOverrideIDs = get_field('stories') ? : $storyIDs;
} else {
    $storyOverrideIDs = get_sub_field('stories_swiper_overrides') ? : get_field('stories');
}
$overrideClass = get_sub_field('stories_swiper_overrides') || get_field('stories') || $storyIDs ? 'stories-override' : "";
$args = [
    'post_type' => 'story',
    'post_status' => 'publish',
    'posts_per_page' => 10,
    'post__in' => $storyOverrideIDs
];
$stories = new WP_Query( $args ); ?>
<div class="<?= $newsRowClass; ?> stories <?= $overrideClass; ?>">
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-right-yellow.svg'); ?>
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-cyan-short.svg'); ?>
    <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-left-red.svg'); ?>
    <div class="container">
        <div class="title-section text-center">
            <?php
            if(is_singular('course')){ ?>
                <h2>Student Stories</h2>
            <?php } else {
                if (get_field('story_title') || get_field('story_description')) {
                    if (get_field('story_title')) { ?>
                        <h2><?php the_field('story_title'); ?></h2>
                    <?php }
                    if (get_field('story_description')) {
                        the_field('story_description');
                    }
                } else {
                    if (get_sub_field('story_title')) { ?>
                        <h2><?php the_sub_field('story_title'); ?></h2>
                    <?php }
                    if (get_sub_field('story_description')) {
                        the_sub_field('story_description');
                    }
                }
            }?>
        </div>

        <div class="custom-swiper-controls">
            <div class="story-swiper-prev custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
            <div class="story-swiper-next custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
        </div>

        <div class="swiper-container story-swiper">
            <div class="swiper-wrapper" role="feed">
                <?php while ( $stories->have_posts() ) {
                    $stories->the_post();
                    $terms = get_the_terms(get_the_id(), 'category');
                    $name = get_the_title();
                    $splitName = explode(' ',trim($name));
                    $featuredImage = get_the_post_thumbnail_url(get_the_id(), 'story-image');
                    $image = $featuredImage ? $featuredImage : get_field('default_image_logo', 'option') ;
                    $storyCTAText = get_field('override_story_cta_text') ? : "Read more about " . $splitName[0] . "'s story"
                    ?>
                    <article class="swiper-slide">
                        <a href="<?php the_permalink(); ?>" aria-label="Open <?= $splitName[0] . "'s"; ?> Story">
                            <div class="story-item">
                                <div class="top-story-section">
                                    <div class="image <?php if(!$featuredImage){ echo 'no-post-thumbnail'; } ?>">
                                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                    </div>
                                    <div class="titles">
                                        <h3><?php the_title(); ?></h3>
                                        <?php if($terms) { ?><h4><?= $terms[0]->name; ?></h4><?php } ?>
                                    </div>
                                </div>
                                <?php the_field('story_quote'); ?>
                                <div class="text-cta">
                                    <?php ?>
                                    <span class="underline"><?= $storyCTAText; ?></span><i class="fal fa-long-arrow-right"></i>
                                </div>
                            </div>
                        </a>
                    </article>
                <?php } wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
</div>
