<?php

$gallery = get_field('gallery');
$title = get_the_title();
$galleryCount = 1;
if($gallery) { ?>
    <div class="flexible-layout-block gallery-block course-gallery">
        <div class="gallery-block-section">
            <div class="swiper-container gallery-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($gallery as $image) {

                        $imageURL = wp_get_attachment_image_src( $image['ID'], 'news-image' );
                        $image = $imageURL[0] ? : get_field('default_image_logo', 'option');

                        ?>
                        <div class="swiper-slide"><img src="<?= $image ?>" alt="<?= $title . ' Gallery Image ' . $galleryCount ?>"></div>
                    <?php $galleryCount++; } ?>
                </div>
            </div>
        </div>
        <div class="custom-prev-button gallery-nav">
            <i class="far fa-chevron-left"></i>
        </div>
        <div class="custom-next-button gallery-nav">
            <i class="far fa-chevron-right"></i>
        </div>
        <div class="swiper-pagination"></div>
    </div>
<?php } ?>
