<?php
$rowClass = get_row_index() == 2 ? 'secondary-block' : 'normal-block';
?>
<div class="flexible-layout-block student-block <?= $rowClass ?>">
    <div class="container-fluid">
        <div class="row">
            <?php if( have_rows('student_block') ) { ?>
                <?php while (have_rows('student_block')) {
                    the_row(); ?>
                    <div class="col-xl student-col d-flex justify-content-center">
                        <div class="student-item">
                            <h3><?php the_sub_field('student_block_title'); ?></h3>
                            <h4><?php the_sub_field('student_block_secondary_title'); ?></h4>
                            <?php if( have_rows('student_links') ) { ?>
                                <ul role="list">
                                    <?php while (have_rows('student_links')) {
                                        the_row();
                                        $cta = get_sub_field('student_link');
                                        if ($cta) {?>
                                            <li role="listitem"><a href="<?= $cta['url'] ?>"><?= $cta['title']; ?></a>
                                            </li>
                                        <?php }
                                    }?>
                                </ul>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
    </div>
</div>
