<?php
$id = get_the_id();
$categoryColour = Blue2\Scruffy\Site::getParentCategoryColour($id);
$locations = Blue2\Scruffy\Controllers\CourseController::getCourseCampuses($id);
$modesOfStudy = Blue2\Scruffy\Controllers\CourseController::getCourseModesOfStudy($id);
$levels = Blue2\Scruffy\Controllers\CourseController::getCourseLevels($id);
$subjects = Blue2\Scruffy\Controllers\CourseController::getCourseSubjects($id);
$courseInstances = Blue2\Scruffy\Controllers\CourseController::getCourseInstances($id);

if($courseInstances) {
    $instanceDurations = $courseInstances['duration'];
    $instanceStartDates = $courseInstances['start_dates'];
    $instanceFees = $courseInstances['fees'];
}
?>
<style>
    body{
        --course-colour: <?= $categoryColour; ?>;
    }
</style>

<div class="custom-single-course" id="main-area">
    <?= get_template_part('templates/sections/course/course-hero') ?>
    <main class="course-main" role="main">
        <div class="container">
            <div class="course-info-bar">
                <div class="row row-eq-height no-gutters">
                    <?php
                    $qualificationType = get_field('qualification_type');
                    if($qualificationType || $levels) { ?>
                        <div class="col-lg-12 col-xl col-xxl info-col">
                            <div class="info-item">
                                <h2>Qualification</h2>
                                <p><?php Blue2\Scruffy\Controllers\CourseController::qualificationOutput($levels, get_field('qualification_type')); ?></p>
                            </div>
                        </div>
                    <?php }
                    if(!empty($instanceDurations)) {
                        $uniqueInstances = array_unique($instanceDurations);
                        if(count($uniqueInstances) > 1) {
                            $durationOutput = "Varies";
                        } else {
                            $durationOutput = $uniqueInstances[0];
                        } ?>
                        <div class="col-lg-12 col-lg-6 col-xl info-col">
                            <div class="info-item">
                                <h2>Duration</h2>
                                <p><?= $durationOutput; ?></p>
                            </div>
                        </div>
                    <?php }
                    
                    if(!empty($instanceStartDates)) {
                        $startCheck = Blue2\Scruffy\Controllers\CourseController::getCourseInstanceStartDates($instanceStartDates);
                        if ($startCheck !== 'No dates available' || ($startCheck == 'No dates available' && in_array('SMA', $modesOfStudy))) { ?>
                            <div class="col-lg-12 col-lg-6 col-xl info-col">
                                <div class="info-item">
                                    <h2>Starts</h2>
                                    <p><?= $startCheck; ?></p>
                                </div>
                            </div>
                        <?php }
                    }

                    if (!empty($courseItem['modes_of_study']) && !in_array('SMA', $modesOfStudy)) { ?>
                        <div class="col-lg-12 col-lg-6 col-xl info-col">
                            <div class="info-item">
                                <h2>Mode of Study</h2>
                                <ul role="list">
                                    <?php foreach($modesOfStudy as $mode) { ?>
                                        <li role="listitem"><?= $mode; ?></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    <?php }
                    if(!empty($instanceFees)) {
                        $uniqueInstances = array_unique($instanceFees);
                        if(count($uniqueInstances) > 1) {
                            $feesOutput = $uniqueInstances[0] . '<br/> (Varies)';
                        } else {
                            $feesOutput = $uniqueInstances[0];
                        } ?>
                        <div class="col-lg-12 col-lg-6 col-xl info-col">
                            <div class="info-item">
                                <h2>Fees</h2>
                                <p><?= '&pound;' . $feesOutput; ?></p>
                            </div>
                        </div>
                    <?php }
                    if($subjects) { ?>
                        <div class="col-lg-12 col-lg-6 col-xl info-col">
                            <div class="info-item">
                                <h2>Interests</h2>
                                <ul role="list">
                                    <?php foreach($subjects as $subject) { ?>
                                        <li role="listitem"><?= $subject ?></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    <?php }
                    if($locations) { ?>
                        <div class="col-lg-12 col-lg-6 col-xl info-col">
                            <div class="info-item">
                                <h2>Campus</h2>
                                <ul role="list">
                                    <?php
                                    if ($locations && count($locations) <= 2) {
                                        foreach ($locations as $campus) { ?>
                                            <li role="list-item"><?= $campus ?></li>
                                        <?php }
                                    } elseif(count($locations) > 2) { ?>
                                        <li role="list-item">Options Available</li>
                                    <?php } else {
                                        echo 'n/a';
                                    } ?>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="col-lg-12 col-lg-6 col-xl info-col">
                        <div class="info-item apply">
                            <button class="scroll-to-applications" aria-label="Scroll to application section">
                                <h2>Apply</h2>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="course-split-info">
                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-left-yellow.svg'); ?>
                <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-cyan-short-2.svg'); ?>
                <div class="row">
                    <?php if(get_field('why_take_this_course')) { ?>
                        <div class="col-lg-6 first-col">
                            <h2>Why take this course?</h2>
                            <?php the_field('why_take_this_course'); ?>
                        </div>
                    <?php }
                    if(get_field('what_will_i_experience')) { ?>
                        <div class="col-lg-6 second-col">
                            <h2>What you will experience</h2>
                            <?php the_field('what_will_i_experience'); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </main>

    <?php $entryRequirements = get_field('entry_requirements') ?: get_field('entry_requirements_default', 'option');
    if(get_field('entry_requirements') || get_field('entry_requirements_default', 'option')) { ?>
        <div class="entry-requirements-block">
            <div class="container">
                <div class="row">
                    <div class="offset-lg-2 col-lg-8">
                        <div class="opportunity-section text-center">
                            <h2>Key Facts</h2>
                            <?= $entryRequirements; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <?= get_template_part('templates/sections/swipers/info-box-swiper') ?>

    <?php
    $educationCourseOpportunities = get_field('education_course_opportunities');
    $educationDescription = get_field('education_description');
    $uniCourseOpportunities = get_field('university_course_opportunities');
    $uniCourseDescription = get_field('university_description');
    $employmentOpportunities = get_field('employment_opportunities');
    $employmentDescription = get_field('employment_description');

    if(has_term('sma', 'mode-of-study')) {
        $smaTitle = get_field('sma_title', 'option');
        $smaContent = get_field('sma_content', 'option');
        $opportunitiesTitle = get_field('opportunities_title_override') ?: $smaTitle;
        $opportunitiesDescription = get_field('opportunities_description_override') ?: $smaContent;
        $opportunitySections = $opportunitiesTitle || $opportunitiesDescription;
        $smaActiveState = true;
    } else {
        $opportunitiesTitle = get_field('opportunities_title_override') ?: get_field('default_opportunities_title', 'option');
        $opportunitiesDescription = get_field('opportunities_description_override') ?: get_field('default_opportunities_description', 'option');
        $opportunitySections = $educationDescription || $educationCourseOpportunities || $uniCourseDescription || $uniCourseOpportunities || $employmentDescription || $employmentOpportunities;
        $smaActiveState = false;
    }
    ?>

    <?php if($opportunitySections) { ?>
        <div class="opportunities">
            <div class="container">
                <div class="row">
                    <div class="offset-lg-2 col-lg-8">
                        <div class="opportunity-section text-center">
                            <h2><?= $opportunitiesTitle; ?></h2>
                            <?= $opportunitiesDescription; ?>

                            <?php \Blue2\Scruffy\Controllers\CourseController::generateCategoryPDF(); ?>

                        </div>
                    </div>
                </div>
                <div class="split-block">
                    <div class="row">

                        <?php $infoSection = $smaActiveState ? 'offset-lg-3 col-lg-6' : 'col-lg-6'; ?>

                        <div class="<?= $infoSection; ?> d-flex justify-content-center opportunities-block">
                            <?php
                            if(!get_field('opportunities_featured_video') && !get_field('opportunities_featured_image')){
                                $oppClass = 'offset-lg-2 col-lg-8';
                            } else{
                                $oppClass = 'col-lg-6';
                            }
                            if(get_field('opportunities_featured_video')) {
                                $video = get_field('opportunities_featured_video'); ?>
                                <div class="opportunity-media">
                                    <video autoplay muted loop controls class="opportunities-video">
                                        <source src="<?= $video['url']; ?>" type="video/mp4">
                                    </video>
                                </div>
                            <?php }
                            if(get_field('opportunities_featured_image')) { ?>
                                <div class="opportunity-media">
                                    <img src="<?php the_field('opportunities_featured_image'); ?>" alt="Opportunities">
                                </div>
                            <?php } ?>
                        </div>
                        <div class="<?= $oppClass; ?>">
                            <?php if($educationDescription  || $educationCourseOpportunities) { ?>
                                <section class="opportunity-section education-block">
                                    <h3>Education at NESCol</h3>
                                    <?php
                                    echo $educationDescription;
                                    if($educationCourseOpportunities){

                                        $levelName = "";
                                        ?>
                                        <ul role="list">
                                            <?php foreach ($educationCourseOpportunities as $post) {
                                                $levels = get_the_terms($post->ID, 'level');

                                                if($levels && get_field('qualification_type')) {
                                                    $qualificationOutput = get_field('qualification_type') . ' (' . $levels[0]->name . ')';
                                                } elseif(get_field('qualification_type') && !$levels) {
                                                    $qualificationOutput = get_field('qualification_type');
                                                } else{
                                                    $qualificationOutput = "";
                                                }

                                                ?>
                                                <li role="listitem"><a href="<?= get_the_permalink($post->ID); ?>"><?= $post->post_title ?><?php if($qualificationOutput) { echo ' - ' . $qualificationOutput; } ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } wp_reset_postdata(); ?>
                                </section>
                            <?php } if($uniCourseOpportunities || $uniCourseDescription) { ?>
                                <section class="opportunity-section university-block">
                                    <h3>University</h3>
                                    <?php
                                    echo $uniCourseDescription;
                                    if( have_rows('university_course_opportunities') ) { ?>
                                        <ul role="list">
                                            <?php while ( have_rows('university_course_opportunities') ) {
                                                the_row(); ?>
                                                <li role="listitem">
                                                    <?php if(get_sub_field('university_url')) { ?>
                                                    <a href="<?php the_sub_field('university_url'); ?>" target="_blank"><?php } ?>
                                                        <?php
                                                        if(get_sub_field('university_course')){
                                                            $output = get_sub_field('university_name') . ' - ' . get_sub_field('university_course');
                                                        } else{
                                                            $output = get_sub_field('university_name');
                                                        }
                                                        echo $output;
                                                        ?>
                                                        <?php if(get_sub_field('university_url')) { ?></a><?php } ?>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </section>
                            <?php } if($employmentDescription || $employmentOpportunities) { ?>
                                <section class="opportunity-section employment-block">
                                    <h3>Employment</h3>
                                    <?php
                                    echo $employmentDescription;
                                    if( have_rows('employment_opportunities') ) { ?>
                                        <ul role="list">
                                            <?php while ( have_rows('employment_opportunities') ) {
                                                the_row(); ?>
                                                <li class="employment-list-item" role="listitem"><?php the_sub_field('opportunity'); ?></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </section>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <div class="container">
        <?= get_template_part('templates/sections/course/course-gallery'); ?>
    </div>

    <div class="course-stories">
        <?= get_template_part('templates/sections/swipers/story-swiper') ?>
    </div>

    <?= get_template_part('templates/sections/course/course-applications') ?>

    <?= get_template_part('templates/sections/swipers/related-course-posts-swiper'); ?>
</div>
