<?php
$locationArgs = [
    'post_type' => 'location',
    'posts_per_page' => 50,
    'orderby' => 'title',
    'order' => 'ASC',
    'tax_query' => [
        [
            'taxonomy' => 'location-type',
            'field' => 'slug',
            'terms' => ['campus', 'learning-centre'],
        ]
    ]
];
$coordinates = [];
$locationQuery = new WP_Query($locationArgs);

if ( $locationQuery->have_posts() ) {
    while ($locationQuery->have_posts()) {
        $locationQuery->the_post();
        $address = get_field('map');
        if($address) {
            array_push($coordinates, [get_the_title(), $address['lng'], $address['lat'], get_permalink()]);
        }
    }
}
wp_reset_postdata();
?>
<div class="custom-contact-template" id="main-area">
    <div class="courses-by-hero contact-hero" style="background-image:url('<?php the_post_thumbnail_url(); ?>');">
        <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-cyan-vertical.svg'); ?>
        <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-right-red.svg'); ?>
        <div class="container d-flex align-items-center">
            <div class="title-section">
                <h1><?php the_title(); ?></h1>
                <?php the_content(); ?>
            </div>
        </div>
    </div>

    <main class="contact-main" role="main">
        <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/top-left-cyan-vertical.svg'); ?>
        <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-right-yellow.svg'); ?>
        <div class="container">
            <h2 class="contact-title"><?php the_field('main_section_title'); ?></h2>
            <?php if( have_rows('contact_blocks_section') ) {
                while (have_rows('contact_blocks_section')) {
                    the_row(); ?>
                    <div class="department-block">
                        <div class="row row-eq-height">
                            <div class="col-lg-3">
                                <h3 class="section-title"><?php the_sub_field('section_title'); ?></h3>
                            </div>
                            <div class="col-lg-9">
                                <div class="row">
                                    <?php if( have_rows('section_blocks') ) { ?>
                                        <?php while (have_rows('section_blocks')) {
                                            the_row(); ?>
                                            <div class="col-lg-6 col-xl-4 department-col">
                                                <div class="department-section h-100">
                                                    <?php the_sub_field('content'); ?>
                                                    <ul class="contact-info" role="list">
                                                        <li role="listitem">Telephone: <a href="tel:<?= str_replace(" ", "", get_sub_field('telephone')); ?>"><?php the_sub_field('telephone'); ?></a></li>
                                                        <li>Email: <a href="mailto:<?php the_sub_field('email'); ?>"><?php the_sub_field('email'); ?></a></li>
                                                    </ul>
                                                    <?php if( have_rows('opening_hours') ) { ?>
                                                        <button class="trigger-opening-hours" aria-label="View opening hours">Opening Hours <i class="far fa-chevron-down"></i></button>
                                                        <ul class="opening-hours" role="list">
                                                            <?php while (have_rows('opening_hours')) {
                                                                the_row(); ?>
                                                                <li role="listitem"> <?php the_sub_field('day'); ?> - <?php the_sub_field('time'); ?></li>
                                                            <?php } ?>
                                                        </ul>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        <?php }
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
            } ?>
        </div>
        <?php if( have_rows('info_boxes') ) { ?>
            <h2 class="info-title">Additional Information</h2>
            <?php get_template_part('templates/sections/swipers/info-box-swiper') ?>
        <?php } ?>
    </main>


    <?php if(get_field('map')) {
        $location = get_field('map'); ?>
        <div id="map" data-map-center-lat="<?= $location['lat']; ?>" data-map-center-lng="<?= $location['lng']; ?>" data-map-zoom="<?php the_field('map_zoom'); ?>" data-locations="<?= htmlspecialchars(json_encode($coordinates)); ?>"></div>
    <?php } ?>

    <?php if ( $locationQuery->have_posts() ) {?>
        <div class="locations">
            <div class="container">
                <div class="row row-eq-height">
                    <?php while ( $locationQuery->have_posts() ) {
                        $locationQuery->the_post();
                        $address = get_field('map'); ?>
                        <section class="col-lg-6 col-xl-4 col-xxl-3 contact-col">
                            <div class="contact-location h-100">
                                <h3 class="trigger-map-zoom"><?php the_title(); ?></h3>
                                <?php the_field('address'); ?>
                            </div>
                        </section>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>
</div>
