import Swiper from 'swiper';

const blog = () => {
    $(window).on('resize load', function() {
        const screenWidth = $(window).width();
        if (screenWidth < 1400) {
            $('.event-feed').addClass('swiper-wrapper');
            new Swiper('.blog-events-swiper', {
                loop: true,
                slidesPerView: 1,
                spaceBetween: 25,
                keyboard: {
                    enabled: true,
                },
                breakpoints: {
                    992: {
                        slidesPerView: 1,
                    },
                    1200: {
                        slidesPerView: 2,
                    },
                    1400: {
                        spaceBetween: 50,
                        slidesPerView: 3,
                    }
                }
            });
        } else {
            $('.event-feed').removeClass('swiper-wrapper');
        }
    });
};

export default blog;
