<?php
$terms = get_the_terms(get_the_id(), 'mode-of-study');

foreach($terms as $term) {
    $checkboxTermSlug = str_replace('-', '_', $term->slug) . '_blocks';
    $checkboxes = get_field($checkboxTermSlug);
    $repeater = $term->slug . '_mode_of_study_info_boxes';
    if (have_rows($repeater, 'option') && $checkboxes) {
        while (have_rows($repeater, 'option')) {
            the_row();
            $class = get_sub_field('block_class');
            $bgSet = get_sub_field('use_parent_subject_background_colour') ? 'use-bg' : 'no-bg';
            if (in_array($class, $checkboxes)) { ?>
                <article class="swiper-slide">
                    <?php if (get_row_layout() == 'text_block') { ?>
                        <div class="info-item text-block <?= $bgSet; ?>">
                            <?php the_sub_field('text'); ?>
                        </div>
                    <?php }
                    if (get_row_layout() == 'image_block') {
                        $image = get_sub_field('image'); ?>
                        <div class="info-item image-block <?= $bgSet; ?>">
                            <img src="<?= $image['url']; ?>">
                        </div>
                    <?php } elseif (get_row_layout() == 'bold_message_block') { ?>
                        <div class="info-item bold-message-block <?= $bgSet; ?>">
                            <span class="large-text"><?php the_sub_field('large_text'); ?></span> <span
                                    class="normal-text"><?php the_sub_field('normal_text'); ?></span>
                        </div>
                    <?php } ?>
                </article>
            <?php }
        }
    }
}
