<?php
$id = get_the_id();
$categoryColour = Blue2\Scruffy\Site::getParentCategoryColour($id);
$locations = Blue2\Scruffy\Controllers\CourseController::getCourseCampuses($id);
$modesOfStudy = Blue2\Scruffy\Controllers\CourseController::getCourseModesOfStudy($id);
$levels = Blue2\Scruffy\Controllers\CourseController::getCourseLevels($id);
$subjects = Blue2\Scruffy\Controllers\CourseController::getCourseSubjects($id);
$courseInstances = Blue2\Scruffy\Controllers\CourseController::getCourseInstances($id);
if($courseInstances) {
    $instanceDurations = $courseInstances['duration'];
    $instanceStartDates = $courseInstances['start_dates'];
    $instanceFees = $courseInstances['fees'];
}
$qualificationType = get_field('qualification_type');
$opportunitiesTitle = get_field('opportunities_title_override') ? get_field('opportunities_title_override') : get_field('default_opportunities_title', 'option');
$opportunitiesDescription= get_field('opportunities_description_override') ? get_field('opportunities_description_override') : get_field('default_opportunities_description', 'option');
$companyLogo = get_field('company_logo', 'option');
?>
<div class="hidden-pdf">
    <div id="course-pdf-generation">
        <div class="above-top">
            <p class="nescol-name">North East Scotland College</p>
            <p class="academic-calendar">Academic Calendar 2019/2020</p>
        </div>
        <div class="top-block">
            <div class="stats"><?php if($levels || $qualificationType) { Blue2\Scruffy\Controllers\CourseController::qualificationOutput($levels, get_field('qualification_type')); } ?></div>
            <h1 id="course-title"><?php the_title(); ?></h1>
            <?php the_content(); ?>
        </div>
        <div class="pdf-section">
            <h2>Why take this course?</h2>
            <?php the_field('why_take_this_course'); ?>
            <h2>What you will experience</h2>
            <?php the_field('what_will_i_experience'); ?>
        </div>
        <div id="opportunities" class="pdf-section">
            <h2><?= $opportunitiesTitle; ?></h2>
            <?= $opportunitiesDescription; ?>
        </div>
        <?php $related = get_field('education_course_opportunities');
        if(get_field('education_description')  || $related) { ?>
            <div class="opportunity-section education-block pdf-section">
                <h2>Education at NESCol</h2>
                <?php the_field('education_description');
                if($related){ ?>
                    <ul role="list">
                        <?php foreach ($related as $post){ ?>
                            <li role="listitem"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                        <?php } ?>
                    </ul>
                <?php } wp_reset_postdata(); ?>
            </div>
        <?php } if(get_field('university_description') || get_field('university_course_opportunities')) { ?>
            <div class="opportunity-section university-block pdf-section">
                <h2>University</h2>
                <?php the_field('university_description');
                if( have_rows('university_course_opportunities') ) { ?>
                    <ul role="list">
                        <?php while ( have_rows('university_course_opportunities') ) {
                            the_row(); ?>
                            <li role="listitem">
                                <?php if(get_sub_field('university_url')) { ?>
                                <a href="<?php the_sub_field('university_url'); ?>" target="_blank"><?php } ?>
                                    <?php
                                    if(get_sub_field('university_course')){
                                        $output = get_sub_field('university_name') . ' - ' . get_sub_field('university_course');
                                    } else{
                                        $output = get_sub_field('university_name');
                                    }
                                    echo $output;
                                    ?>
                                    <?php if(get_sub_field('university_url')) { ?></a><?php } ?>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        <?php } if(get_field('employment_description') || get_field('employment_opportunities')) { ?>
            <div class="opportunity-section employment-block pdf-section">
                <h2>Employment</h2>
                <?php the_field('employment_description');
                if( have_rows('employment_opportunities') ) { ?>
                    <ul role="list">
                        <?php while ( have_rows('employment_opportunities') ) {
                            the_row(); ?>
                            <li role="listitem" class="employment-list-item"><?php the_sub_field('opportunity'); ?></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        <?php } ?>
        <?php if(get_field('academic_tutor_default', 'option')) { ?>
            <div class="defualt-sections">
                <h2>Academic Tutor</h2>
                <?php the_field('academic_tutor_default', 'option'); ?>
            </div>
        <?php }
        if(get_field('student_advice_centre_default', 'option')) { ?>
            <div class="defualt-sections">
                <h2>Student Advice Centre</h2>
                <?php the_field('student_advice_centre_default', 'option'); ?>
            </div>
        <?php }
        if(get_field('learning_resources_default', 'option')) { ?>
            <div class="defualt-sections">
                <h2>Learning Resources</h2>
                <?php the_field('learning_resources_default', 'option'); ?>
            </div>
        <?php }
        if(get_field('college_calendar_default', 'option')) { ?>
            <div class="defualt-sections">
                <h2>College Calendar</h2>
                <?php the_field('college_calendar_default', 'option'); ?>
            </div>
        <?php } ?>
        <hr class="contact-split-bar" style="border: 2px solid <?= $categoryColour; ?>" />
        <div class="contact-message">
            <?php the_field('contact_message', 'option'); ?>
        </div>
    </div>
</div>