<?php


namespace Blue2\Scruffy\Controllers;

use WP_Post;

class UniteController
{
    public function __construct()
    {
        set_time_limit(-1);

        add_action('partTimeImport', [$this, 'unitePartTimeImport'], 10);

        add_action('fullTimeImport', [$this, 'uniteImport'], 10);
    }

    public static function startUniteFullTimeImport()
    {
        if ( !wp_next_scheduled('fullTimeImport') ) {
            //run this in 30 seconds time
            wp_schedule_single_event(time() + 30, 'fullTimeImport');
        }
    }

    public function uniteImport()
    {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');

        $courseInstances = $this->getAllCurrentCourseCodes();
        $allCourseData = $this->getUniteData("http://195.194.136.164/NescolData/UniteWs.asmx/GetCourseAll");        
        $allCourses = $this->getCourseParents();
        
        $found = 0;
        $notFound = 0;
        $added = 0;
        $updated = 0;

        ob_start();

        foreach ($allCourseData as $ref => $info) {
            $count++;
            if (!array_key_exists($ref, $courseInstances)) {
                $success++;
                $parts = explode('-', $ref);
                $courseCode = $parts[0];
                $instance = array_pop($parts);
                $showStatus = $info['ONLINE'] == 'Y' ? true : false;

                if (array_key_exists($courseCode, $allCourses)) {
                    $post_id = $allCourses[$courseCode];

                    $found++;
                    $instances = get_field("course_instances", $post_id);
                    $row = ['code' => implode('-', $parts), 'instance' => $instance, 'show_on_site' => $showStatus];
                    if(add_row('field_5d5d6a2d24559', $row, $post_id))
                    {
                        $added++;
                    }
                    $this->updateCourseInstance($post_id, $allCourseData[$ref]);
                } else {
                    $notFound++;
                }
            } else {
                $post_id = $courseInstances[$ref]['post_id'];
                $this->updateCourseInstance($post_id, $allCourseData[$ref]);
                $updated++;
            }
        }

        $info = ob_get_clean();

        wp_mail( 'shane@blue2.co.uk', 'Full Time Import', $info );
        die;
    }

    public static function startUnitePartTimeImport()
    {
        if ( !wp_next_scheduled('partTimeImport') ) {
            //run this in 30 seconds time
            wp_schedule_single_event(time() + 30, 'partTimeImport');
        }
    }

    public function unitePartTimeImport()
    {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');

        $courseInstances = $this->getAllCurrentCourseCodes();
        $allCourseData = $this->getPartTimeUniteData("http://195.194.136.164/NescolData/UniteWs.asmx/GetPartTimeCourseFeed?year=2021");
        $allCourses = $this->getCourseParents();
        
        $found = 0;
        $notFound = 0;
        $added = 0;
        $updated = 0;

        ob_start();

        foreach ($allCourseData as $ref => $info) {
            $count++;
            if (!array_key_exists($ref, $courseInstances)) {
                $success++;
                $parts = explode('-', $ref);
                $courseCode = $parts[0];
                $instance = array_pop($parts);
                $showStatus = $info['ONLINE'] == 'Y' ? true : false;

                if (array_key_exists($courseCode, $allCourses)) {
                    $post_id = $allCourses[$courseCode];

                    $found++;
                    $instances = get_field("course_instances", $post_id);
                    $row = ['code' => implode('-', $parts), 'instance' => $instance, 'show_on_site' => $showStatus];
                    if(add_row('field_5d5d6a2d24559', $row, $post_id))
                    {
                        $added++;
                    }
                    $this->updatePartTimeCourseInstance($post_id, $allCourseData[$ref]);
                } else {
                    $notFound++;
                }
            } else {
                $post_id = $courseInstances[$ref]['post_id'];
                $this->updatePartTimeCourseInstance($post_id, $allCourseData[$ref]);
                $updated++;
            }
        }

        echo $found . 'were found <br>';
        echo $notFound . 'were not found <br>';
        echo $added . 'were added <br>';
        echo $updated . 'were updated <br>';

        $info = ob_get_clean();

        wp_mail( 'shane@blue2.co.uk', 'Part Time Import', $info );

        die();
    }

    private function getUniteData($url)
    {
        $xml = simplexml_load_file($url);
        $json = json_encode($xml);
        $courses = json_decode($json, true);
        $courses = $courses['getCourseInfoAllResult'];

        $uniteCourses = [];
        foreach ($courses as $course) {
            // unset($course['INSTANCE']);
            unset($course['VARIATION']);
            $uniqueCode = $course['CREF'] . "-" . $course['INSTANCE'];
            $uniteCourses[$uniqueCode] = array_filter($course);
        }

        return $uniteCourses;
    }

    public function getPartTimeUniteData($url)
    {
        $xml = simplexml_load_file($url);
        $json = json_encode($xml);
        $courses = json_decode($json, true);
        $courses = $courses['CourseFeed'];

        $uniteCourses = [];
        foreach ($courses as $course) {
            // unset($course['INSTANCE']);
            unset($course['VARIATION']);
            $uniqueCode = $course['CREF'] . "-" . $course['INSTANCE'];
            $uniteCourses[$uniqueCode] = array_filter($course);
        }

        return $uniteCourses;
    }

    private function uniteDateToString($date)
    {
        if (trim($date) !== '') {
            return date('Y-m-d', $date);
        }

        return null;
    }

    private function uniteTextToBoolean($data)
    {
        return $data === 'Y';
    }

    public function getAllCurrentCourseCodes()
    {
        $instances = [];

        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');

        $args = array(
            'post_type' => 'course',
            'posts_per_page'   => -1,   
        );
        $query = new \WP_Query($args);

        while ( $query->have_posts() ) : $query->the_post();
            $post_id = get_the_id();
            if (have_rows('course_instances', $post_id)) {
                $postStatus = get_post_status ($post_id);
                while (have_rows('course_instances', $post_id)) {
                    the_row();
                    $instanceNumber = get_sub_field('field_5dc58094fcce7');
                    $code = get_sub_field('field_5d5d6a622455d');
                    $uniqueCode = $code . '-' . $instanceNumber;

                    $instances[$uniqueCode] = [
                        "code" => $code,
                        "post_id" => $post_id,
                        "instance" => $instanceNumber,
                        "id" => $post_id,
                        "post_status" => $postStatus,
                        "ID" => $post_id
                    ];
                }
            }
        endwhile;

        wp_reset_postdata();

        return $instances;
    }

    public function getCourseParents() {
        $args = array(
            'post_type' => 'course',
            'posts_per_page'   => -1,   
        );
        $query = new \WP_Query($args);
        $courseParents = [];

        while ( $query->have_posts() ) : $query->the_post();
            $key = get_post_meta( get_the_ID(), 'course_reference', true );;
            $courseParents[$key] = get_the_ID();
        endwhile;

        wp_reset_postdata();

        return $courseParents;
    }

    private function updateCourseInstance($courseId, $courseData)
    {
        $rows = get_field('course_instances', $courseId);
        foreach ($rows as $key => $row) {
            if ($row['code'] === $courseData['CREF'] && $row['instance'] === $courseData['INSTANCE']) {
                $startDate = $this->uniteDateToString($courseData['START_DATE']);
                if ($startDate !== null) {
                    $row['start_date'] = $startDate;
                }

                $endDate = $this->uniteDateToString($courseData['END_DATE']);
                if ($endDate !== null) {
                    $row['end_date'] = $endDate;
                }

                if (isset($courseData['DAY']) && is_string($courseData['DAY'])) {
                    $day = trim($courseData['DAY']);
                    if ($day !== '') {
                        $row['day'] = $day;
                    }
                }

                if (isset($courseData['TIME']) && is_string($courseData['TIME'])) {
                    $time = trim($courseData['TIME']);
                    if ($time !== '') {
                        $row['time'] = $time;
                    }
                }

                $row['show_on_site'] = !$this->uniteTextToBoolean($courseData['HIDE']);
                $row['online'] = $this->uniteTextToBoolean($courseData['ONLINE']);

                $test = update_row('course_instances', $key+1, $row, $courseId);
            }
        }
    }

    private function updatePartTimeCourseInstance($courseId, $courseData)
    {
        dump($courseId);
        $rows = get_field('field_5d5d6a2d24559', $courseId);
        dump($rows);
        foreach ($rows as $key => $row) {

            echo "Row Code: " . $row['code'] . "--------- CourseData (CREF): " . $courseData['CREF'] . "--------- Instances: " . $row['instance'] . "-" . $courseData['INSTANCE'] . "\n";

            if ($row['code'] === $courseData['CREF'] && $row['instance'] === $courseData['INSTANCE']) {

                if($courseData['STARTDATE']) {
                    $startDate = $this->uniteDateToString($courseData['STARTDATE']);
                    if ($startDate !== null) {
                        $row['start_date'] = $startDate;
                    }
                }

                if($courseData['ENDDATE']) {
                    $endDate = $this->uniteDateToString($courseData['ENDDATE']);
                    if ($endDate !== null) {
                        $row['end_date'] = $endDate;
                    }
                }

                if (isset($courseData['DAY']) && is_string($courseData['DAY'])) {
                    $day = trim($courseData['DAY']);
                    if ($day !== '') {
                        $row['day'] = $day;
                    }
                }

                if (isset($courseData['TIME']) && is_string($courseData['TIME'])) {
                    $time = trim($courseData['TIME']);
                    if ($time !== '') {
                        $row['time'] = $time;
                    }
                }

                if (isset($courseData['FEES']) && is_string($courseData['FEES'])) {
                    $fees = trim($courseData['FEES']);
                    if ($fees !== '') {
                        $row['fees'] = number_format($fees, 2);
                    }
                }

                if (isset($courseData['PLACESAVAILABLE']) && is_string($courseData['PLACESAVAILABLE'])) {
                    $places = trim($courseData['PLACESAVAILABLE']);
                    if ($places !== '' || $places == 0) {
                        $row['places_available'] = true;
                    }
                }

                if (isset($courseData['LOCATION']) && is_string($courseData['LOCATION'])) {
                    $location = trim($courseData['LOCATION']);
                    $slugLocation = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', strtolower($location))));
                    $queried_post = get_page_by_path($slugLocation, OBJECT, 'location');

                    if ($location !== '' || $location == 0) {
                        $row['location'] = $queried_post;
                    }
                }

                //$row['show_on_site'] = !$this->uniteTextToBoolean($courseData['HIDE']);
                $row['online'] = $this->uniteTextToBoolean($courseData['ONLINE']);

                $test = update_row('course_instances', $key+1, $row, $courseId);
            }
        }
    }
}
