<?php
$levelArray = [];
$levels = get_the_terms(get_the_id(), 'level');
$heroVideo = get_field('hero_video');
if($levels) {
    foreach ($levels as $level) {
        array_push($levelArray, $level->name);
    }
}
$compareSession = Blue2\Scruffy\Controllers\CourseController::checkCompareSession(get_the_id());
$compareClass = ($levels || get_field('qualification')) ? 'levels-present' : 'no-levels';


if($levels || get_field('qualification_type')) { ?>
    <span class="qualification-scqf"><?php Blue2\Scruffy\Controllers\CourseController::qualificationOutput($levelArray, get_field('qualification_type')); ?></span>
<?php }
if(has_tag('coming-soon', get_the_id())) { ?>
    <span class="coming-soon">Coming soon</span>
<?php }
if(get_field('activate_course_compare', 'option')) { ?>
    <span class="course-compare <?= $compareClass; ?>">
        <button aria-label="<?= "Compare toggle for the " . get_the_title() . ' course'; ?>" data-course-id="<?= get_the_id(); ?>" id="<?= 'compare-item-' . get_the_id();  ?>" class="add-to-compare <?= $compareSession['button_state']; ?>"><i class="<?= $compareSession['font_awesome_class'] ?> fa-square custom-compare-svg"></i>Compare Course</button>
    </span>
<?php } ?>
<h1><?php the_title(); ?></h1>
<?php the_content(); ?>
<div class="download">
    <form action="" method="post" enctype="multipart/form-data">
        <input type="submit" id="downloadPDFBrochure" value="Download the course brochure" aria-label="Download the <?php the_title(); ?> brochure" name="downloadCourseBrochure">
        <input type="hidden" name="postid" value="<?php the_ID(); ?>" />
    </form>
</div>