<?php
$term = get_term_by( 'slug', get_query_var( 'news-type' ), get_query_var( 'taxonomy' ) );
?>

<div class="courses-by-hero news-hero">
    <div class="container d-flex align-items-center">
    </div>
</div>

<main class="custom-taxonomy-news-type" role="main" id="main-area">
    <div class="container">
        <div class="taxonomy-section">
            <h1><?= $term->name; ?></h1>
            <?php
            $newsArgs = [
                'post_type' => 'post',
                'posts_per_page' => 50,
                'tax_query' => [
                    [
                        'taxonomy' => 'news-type',
                        'terms' => $term->slug,
                        'field' => 'slug',
                        'operator' => 'IN'
                    ]
                ]
            ];
            $newsTypeCount = 0;
            $newsTypeQuery = new WP_Query($newsArgs);
            if ($newsTypeQuery->have_posts()) { ?>
                <div class="more-articles">
                    <div class="container">
                        <div class="row d-flex justify-content-center">
                            <?php while ($newsTypeQuery->have_posts()) {
                                $newsTypeQuery->the_post();
                                $newsTypeCount++;

                                if($newsTypeCount >= 1 && $newsTypeCount <= 3){
                                    $moreClass = 'col-lg-6 col-xl-4';
                                } else{
                                    $moreClass = 'col-lg-6 col-xl-3';
                                }

                                $categories = get_the_terms(get_the_id(), 'news-type');

                                $image = get_the_post_thumbnail_url() ? get_the_post_thumbnail_url() : get_field('default_image_logo', 'option');
                                $imageClass = get_the_post_thumbnail_url() ? 'featured-image' : "default-image";
                                ?>

                                <div class="<?= $moreClass; ?> news-col news-section">
                                    <div class="card">
                                        <article class="news-article">
                                            <div class="image-holder <?= $imageClass; ?>">
                                                <a href="<?php the_permalink(); ?>">
                                                    <img src="<?= $image; ?>" class="card-img-top" alt="<?php the_title(); ?>">
                                                </a>
                                            </div>
                                            <div class="card-body">
                                                <ul class="categories" role="list">
                                                    <?php foreach($categories as $cat) {
                                                        $categoryColour = get_field('category_colour', 'news-type_' . $cat->term_id); ?>
                                                        <li role="listitem"><a href="<?= get_category_link($cat->term_id); ?>" style="background-color:<?= $categoryColour ?>" aria-label="Open <?= $cat->name; ?> Category"><?= $cat->name; ?></a></li>
                                                    <?php } ?>
                                                </ul>
                                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                <h3 class="date"><?= get_the_date('d.m.y') ?></h3>
                                            </div>
                                        </article>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</main>

