<?php $accordionString = \Blue2\Scruffy\Site::generateRandomString(); ?>
<div class="split-block-section accordion-block">
    <div class="accordion-container">
        <div class="accordion" id="<?= 'split-accordion-' . $accordionString ?>">
            <?php if(have_rows('accordion_block')) { ?>
                <?php while (have_rows('accordion_block')) {
                    the_row();
                    $s = substr(str_shuffle(str_repeat("0123456789abcdefghijklmnopqrstuvwxyz", 3)), 0, 3);
                    $accordionSlug = str_replace(' ', '-', get_sub_field('accordion_title'));
                    $accordionSlug = preg_replace('/[^a-zA-Z0-9]/', '', $accordionSlug) . $s;
                    ?>
                    <div class="card">
                        <div class="card-header" id="<?= $accordionSlug . '-heading' . get_row_index(); ?>">
                            <h2 class="mb-0">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="<?= '#' . $accordionSlug . '-collapse' . get_row_index(); ?>" aria-expanded="true" aria-controls="<?= $accordionSlug . '-collapse' . get_row_index(); ?>">
                                    <h3><?php the_sub_field('accordion_title'); ?></h3>
                                </button>
                            </h2>
                        </div>
                        <div id="<?= $accordionSlug . '-collapse' . get_row_index(); ?>" class="collapse <?= get_row_index() == '1' ? 'show' : ""; ?>" aria-labelledby="<?= $accordionSlug . '-heading' . get_row_index(); ?>" data-parent="<?= '#split-accordion-' . $accordionString ?>">
                            <div class="card-body">
                                <?php the_sub_field('accordion_content'); ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
    </div>
</div>



