import '@babel/polyfill'; // Required for build
import load from './loader'; // Required for loading files dynamically
import 'bootstrap/js/dist/util'; // All Bootstrap JS requires Util
import 'bootstrap/js/dist/collapse'; // Used for nav collapse functionality
import '@fortawesome/fontawesome-pro/js/all.min.js';

import common from './common';
import compare from './compare';
/*
    Basic Event Routing
    -------------------
    Switch on body class that gets applied either due to page, post type or page template
    Replace '-' in the class name with '_'
*/
const route = className => {
    switch (className) {

        case 'single_post':
            load('./post');
            break;
        case 'single_course':
            load('./course.js');
            break;
        case 'post_type_archive_course':
        case 'tag':
            import('./course-archive.js').then(module => {
                const CourseFilter = module.default;
                new CourseFilter();
            });
        case 'blog':
            load('./blog.js');
            break;
        case 'search':
            load('./search.js');
            break;
        case 'template_contact':
            load('./contact.js');
            break;

    }
};

// Fire events once document has loaded
document.addEventListener('DOMContentLoaded', () => {
    common(); // Run common code on every page
    compare(); // Run compare code on every page

    const bodyClasses = document.body.className // Get all body classes,
        .replace(/-/g, '_') // replace dashes with underscores,
        .replace(/page_template_/g, '') // remove prefix 'page_template' from template classes, &
        .split(/\s+/); // split on whitespace

    for (const value of bodyClasses) {
        route(value); // Run javascript for each body class
    }
});
