<?php
$gallery = get_field('gallery');

if($gallery) { ?>
    <div class="container">
        <div class="flexible-layout-block gallery-block">
            <div class="gallery-block-section">
                <div class="swiper-container post-swiper">
                    <div class="swiper-wrapper">
                        <?php foreach($gallery as $image) {  ?>
                            <div class="swiper-slide">
                                <?php
                                $imageURL = wp_get_attachment_image_src( $image['ID'], 'news-image' );
                                $image = $imageURL[0] ? : get_field('default_image_logo', 'option'); ?>
                                <img src="<?= $image ?>">
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="swiper-button-next custom-next-button"><i class="far fa-chevron-right"></i></div>
            <div class="swiper-button-prev custom-prev-button"><i class="far fa-chevron-left"></i></div>

            <div class="swiper-pagination"></div>
        </div>
    </div>

<?php } ?>
