import Swiper from 'swiper';

const search = () => {
    const sliderCount = $('.search-swiper').length;
    for (let i = 1; i <= sliderCount; i++) {
        const sliderName = `.search-swiper-${i}`;
        const prevSlider = `.search-swiper-prev-${i}`;
        const nextSlider = `.search-swiper-next-${i}`;

        new Swiper(sliderName, {
            watchOverflow: true,
            draggable:true,
            loop: false,
            slidesPerView: 4,
            spaceBetween: 25,
            loopAdditionalSlides: 3,
            keyboard: {
                enabled: true,
                onlyInViewport: true,
            },
            navigation: {
                nextEl: nextSlider,
                prevEl: prevSlider,
            },
            breakpoints: {
                768: {
                    slidesPerView: 1.1,
                },
                1200: {
                    slidesPerView: 2,
                },
                1400: {
                    slidesPerView: 3,
                }
            }
        });
    }

    $('.scroll-options ul li a').click(function(e) {
        e.preventDefault();
        const searchSection = $(this).attr('href');
        const newPosition = $(searchSection).offset();
        $('html, body').stop()
            .animate({ scrollTop: newPosition.top - 100 }, 500);
    });
};

export default search;
