<?php
$cats = get_the_terms(get_the_id(), 'category');
if($cats) {
    $args = [
        'post_type' => 'course',
        'post_status' => 'publish',
        'posts_per_page' => 10,
        'post__not_in' => [get_the_id()],
        'cat' => $cats[0]->term_id,
    ];
} else {
    $args = [
        'post_type' => 'course',
        'post_status' => 'publish',
        'posts_per_page' => 10,
        'post__not_in' => [get_the_id()],
    ];
}
$similarCourses = new WP_Query( $args );
if($similarCourses->have_posts()) { ?>
    <div class="similar-courses">
        <?= file_get_contents(get_template_directory_uri() . '/dist/images/svg-shapes/bottom-left-cyan-long.svg'); ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-3 primary-block-col">
                    <div class="primary-block">
                        <h2>Similar courses for you</h2>
                        <?php the_field('similar_courses_description', 'option'); ?>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="secondary-blocks">
                        <section class="posts-carousel">
                            <div class="swiper-container course-swiper">
                                <div class="swiper-wrapper" role="feed">
                                    <?php while ($similarCourses->have_posts()) {
                                        $similarCourses->the_post();
                                        $image = \Blue2\Scruffy\Controllers\CourseController::getCourseImage(get_the_id(), 'news-image'); ?>
                                        <article class="swiper-slide">
                                            <div class="news-item">
                                                <a href="<?php the_permalink(); ?>" aria-label="Open <?= get_the_title(); ?> Article">
                                                    <div class="image-area <?php if(get_the_post_thumbnail_url() == '' && $image['image_format'] == 'cat-not-set') { echo 'no-post-thumbnail'; } ?>">
                                                        <img src="<?= $image['image_url']; ?>" alt="<?php the_title(); ?>">
                                                    </div>
                                                </a>
                                                <div class="content-area">
                                                    <?php
                                                    $qualificationType = get_field('qualification_type');
                                                    $levels = \Blue2\Scruffy\Controllers\CourseController::getCourseLevels(get_the_id());
                                                    if($qualificationType || $levels) { ?>
                                                        <div class="level">
                                                            <?php \Blue2\Scruffy\Controllers\CourseController::qualificationOutput($levels, get_field('qualification_type')); ?>
                                                        </div>
                                                    <?php } ?>
                                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                    <div class="cta-holder">
                                                        <div class="cta">
                                                            <a href="<?php the_permalink(); ?>">View Course</a>
                                                        </div>
                                                        <?php if(get_field('activate_course_compare', 'option')) {
                                                            $compareSession = \Blue2\Scruffy\Controllers\CourseController::checkCompareSession(get_the_id()); ?>
                                                            <div class="course-compare">
                                                                <button class="add-to-compare <?= $compareSession['button_state']; ?>" data-course-id="<?php the_id(); ?>" id="<?= 'compare-item-' . get_the_id(); ?>"><i class="<?= $compareSession['font_awesome_class']; ?> fa-square custom-compare-svg"></i>Compare Course</button>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>
                                    <?php } ?>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php wp_reset_postdata();
} ?>
