<?php
    $image = wp_get_attachment_image(get_sub_field('block_image'), 'full');
    $imagePositioning = get_sub_field('block_image_positioning');
    $imageUnderlay = get_sub_field('block_show_coloured_underlay') ? 'underlay' : "";

    if($imageUnderlay && $imagePositioning == 'fixed'){
        $underlayPositioning = get_sub_field('underlay_positioning') ? : "";
        $underlayColour = get_sub_field('underlay_colour') ? : "";
        $blockClass = "split-block-section image-block image-" . $imagePositioning;
        $containerClass = "image-container " . $imageUnderlay . " " . $underlayPositioning . " underlay-" . $underlayColour;

    } else{
        $blockClass = "split-block-section image-block image-" . $imagePositioning;
        $containerClass = "image-container";
    }

    if(get_sub_field('underlay_positioning')){
        $position = get_sub_field('underlay_positioning');
        switch($position){
            case 'bottom-left':
            case 'bottom-right':
                $offsetClass = 'no-offset';
                break;
            case 'top-right':
            case 'top-left':
                $offsetClass = 'active-offset';
                break;
        }
    }

?>

<div class="<?= $blockClass . ' ' . $offsetClass; ?>">
    <div class="<?= $containerClass; ?>">
        <?= $image; ?>
    </div>
</div>
