<div class="courses-by by-campus">
    <?= get_template_part('templates/sections/courses-by/courses-by-hero'); ?>
    <?= get_template_part('templates/sections/courses-by/courses-by-filter'); ?>
    <main class="course-by-campus-output" role="main" id="main-area">
        <div class="container">
            <?php
            $args = [
                'post_type' => 'location',
                'posts_per_page' => 50,
                'hide_empty' => false,
                'order_by' => 'title',
                'order' => 'ASC',
                'tax_query' => [
                    [
                        'taxonomy' => 'location-type',
                        'terms' => ['campus', 'learning-centre'],
                        'field' => 'slug',
                        'operator' => 'IN'
                    ]
                ]
            ];
            $location = new WP_Query($args);

            if ($location->have_posts()) {
                while ($location->have_posts()) {
                    $location->the_post();
                    $campusImage = get_the_post_thumbnail_url() ? : get_field('default_image_logo', 'option');
                    $campusID = get_the_id();
                    $campusTitle = get_the_title();
                    $campusSlug = get_post_field( 'post_name', get_post());
                    $courseListing = [];
                    ?>
                    <div class="campus-item">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="image-area <?php if(!get_the_post_thumbnail_url()) { echo 'default-campus-image'; } ?>">
                                    <img src="<?= $campusImage; ?>" alt="<?= $campusTitle; ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="content-area">
                                    <h2><?= $campusTitle; ?></h2>
                                    <?php the_content(); ?>

                                    <?php
                                    $campusCoursesArgs = [
                                        'post_type' => 'course',
                                        'posts_per_page' => 20,
                                        'orderby' => 'rand',
                                        'meta_query' => [
                                            [
                                                'key' => 'course_instances_$_location',
                                                'value' => $campusID,
                                                'compare' => 'LIKE'
                                            ],
                                        ]
                                    ];
                                    $courses = new WP_Query($campusCoursesArgs);
                                    if ($courses->have_posts()) {
                                        while ($courses->have_posts()) {
                                            $courses->the_post();
                                            $terms = get_the_terms(get_the_id(), 'category');
                                            $courseListing[] = [get_the_title(), get_the_permalink()];
                                        } wp_reset_postdata();
                                    }
                                    if($courseListing) { ?>
                                        <p>A selection of courses available at our <?= $campusTitle; ?>:</p>
                                        <ul class="course-list" role="list">
                                            <?php foreach($courseListing as $courseListItem) { ?>
                                                <li role="listitem"><a href="<?= $courseListItem[1]; ?>" aria-label="<?= 'View ' . $courseListItem[0] . ' courses at ' . $campusTitle;  ?>"><?= $courseListItem[0]; ?></a></li>
                                            <?Php } ?>
                                        </ul>
                                        <?php
                                    }
                                    ?>
                                    <div class="ctas">
                                        <a href="<?= "/courses/?campus=" . $campusID; ?>" aria-label="<?= 'View all the courses available at ' . $campusTitle;  ?>">View All Courses</a>
                                        <a href="<?= "/location/" . $campusSlug . '/'; ?>" class="invert">Learn More About the Campus</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
            } ?>
        </div>
    </main>
</div>
