import Swiper from 'swiper';
// if you're using a bundler, first import:
import Headroom from 'headroom.js';
// grab an element
const myElement = document.querySelector('.site-header');
// construct an instance of Headroom, passing the element
const headroomOptions = {
    tolerance: 5,
};
const headroom = new Headroom(myElement, headroomOptions);
// initialise
headroom.init();

const common = () => {
    function checkCookie() {
        // Quick test if browser has cookieEnabled host property
        if (navigator.cookieEnabled) {
            return true;
        }
        // Create cookie
        document.cookie = 'cookietest=1';
        const ret = document.cookie.indexOf('cookietest=') !== -1;
        // Delete cookie
        document.cookie = 'cookietest=1; expires=Thu, 01-Jan-1970 00:00:01 GMT';
        return ret;
    }
    function createCookie(name, value, days) {
        console.log(name);
        let expires = '';
        if (days) {
            const date = new Date();
            date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);
            // expires = '; expires=' + date.toGMTString();
            expires = `; expires= ${date.toGMTString()}`;
        } else {
            expires = '';
        }
        // document.cookie = name + '=' + value + expires + '; path=/';
        document.cookie = `${name}=${value}${expires}; path=/`;
    }
    function readCookie(name) {
        const nameEQ = `${name}=`;
        const ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1, c.length);
            }
            if (c.indexOf(nameEQ) === 0) {
                return c.substring(nameEQ.length, c.length);
            }
        }
        return null;
    }
    function eraseCookie(name) {
        createCookie(name, null, -1);
    }

    // Check if cookies are on.
    if (!checkCookie()) {
        $('.settings-drawer').addClass('settings--disabled');
        $('.pin').addClass('pin--disabled');
    }
    //Personalisation vars:
    let pInterests;
    let pPostCats;
    let pPosts;
    let pCourses;
    let pinnedPostsPlaceholder;
    let pinnedInterestPlaceholder;
    let pinClickedFlag = 0;
    function activatePins() {
        if (pInterests.length < 1 && pPosts.length < 1 && pCourses.length < 1 && pinClickedFlag !== 1) {
            $('body').addClass('pinTips pinDrawerTip');
            $('.header-tools .pin-items').removeClass('hide-pintip');
        }
        pInterests.forEach(function(pInterest) {
            $(`[data-pin-id="${pInterest}"]`).addClass('unpin');
        });
        /*
        pPostCats.forEach(function(pPostCats) {
            $(`[data-pin-id="${pPostCats}"]`).addClass('unpin');
        });
        */
        pPosts.forEach(function(pPosts) {
            $(`[data-post-id="${pPosts}"]`).addClass('unpin');
        });
        pCourses.forEach(function(pCourses) {
            $(`[data-pin-id="${pCourses}"]`).addClass('unpin');
        });
    }

    function toggleSettings() {
        $('button.pin-items').toggleClass('pin-items--open');
        $('.settings-drawer').toggleClass('settings-drawer--open');
        $('.settings__expander').toggleClass('settings__expander--expanded');
        $('#settings__expand, #settings__compress').addClass('d-none');
    }

    function closeSettings() {
        $('button.pin-items').removeClass('pin-items--open');
        $('.settings-drawer').removeClass('settings-drawer--open');
        $('.settings__expander').removeClass('settings__expander--expanded');
        $('#settings__expand, #settings__compress').addClass('d-none');
    }

    function openSettings() {
        $('button.pin-items').addClass('pin-items--open');
        $('.settings-drawer').addClass('settings-drawer--open');
        $('.settings__expander').addClass('settings__expander--expanded');
        $('#settings__expand, #settings__compress').addClass('d-none');
    }

    function loadPrefs() {
        pInterests = readCookie('nescol_interests'); // <- subject categories, locations etc.
        pPostCats = readCookie('nescol_postCats');
        pPosts = readCookie('nescol_posts');
        pCourses = readCookie('nescol_courses');
        pinnedPostsPlaceholder = $('.pinned-post-slide--placeholder');
        pinnedInterestPlaceholder = $('.pinned-interests__slide--placeholder');

        if ($('body').hasClass('pinTips') && pinClickedFlag !== 1) {
            pinClickedFlag = 1;
            headroom.pin();
            $('body').removeClass('pinTips pinDrawerTip');
            setTimeout(function() {
                $('.header-tools .pin-items').addClass('hide-pintip');
                openSettings();
            }, 300);
        }
        /*
        console.log(pInterests);
        console.log(pPostCats);
        console.log(pPosts);
        */
        if (pInterests === null) {
            pInterests = [];
        } else {
            pInterests = JSON.parse(pInterests);
            console.log('pInterests:');
            console.log(pInterests);
        }
        if (pPostCats === null) {
            pPostCats = [];
        } else {
            pPostCats = JSON.parse(pPostCats);
            console.log('pPostCats:');
            console.log(pPostCats);
        }
        if (pPosts === null) {
            pPosts = [];
        } else {
            pPosts = JSON.parse(pPosts);
            console.log('pPosts:');
            console.log(pPosts);
        }
        if (pCourses === null) {
            pCourses = [];
        } else {
            pCourses = JSON.parse(pCourses);
            console.log('pCourses:');
            console.log(pCourses);
        }
        activatePins();
    }
    if ($('#settings-drawer').length > 0) {
        loadPrefs();
        const pinnedInterestsSwiper = new Swiper('.settings__course-subjects', {
            slidesPerView: 1.2,
            spaceBetween: 20,
            keyboard: {
                enabled: true,
                onlyInViewport: true,
            },
            breakpoints: {
                768: {
                    spaceBetween: 20,
                    slidesPerView: 2.2,
                },
                992: {
                    spaceBetween: 20,
                    slidesPerView: 2.2,
                },
                1200: {
                    spaceBetween: 20,
                    slidesPerView: 2.2,
                },
                1550: {
                    spaceBetween: 20,
                    slidesPerView: 4.2,
                },
                2920: {
                    spaceBetween: 20,
                    slidesPerView: 5.2,
                },
            },
        });

        const pinnedPostsSwiper = new Swiper('.settings__pinned-posts', {
            slidesPerView: 1.2,
            spaceBetween: 20,
            keyboard: {
                enabled: true,
                onlyInViewport: true,
            },
            breakpoints: {
                480: {
                    spaceBetween: 20,
                    slidesPerView: 1.2,
                },
                560: {
                    spaceBetween: 20,
                    slidesPerView: 2.2,
                },
                768: {
                    spaceBetween: 20,
                    slidesPerView: 2.2,
                },
                992: {
                    spaceBetween: 20,
                    slidesPerView: 4.2,
                },
                1200: {
                    spaceBetween: 20,
                    slidesPerView: 5.2,
                },
                1550: {
                    spaceBetween: 20,
                    slidesPerView: 5.2,
                },
                2920: {
                    spaceBetween: 20,
                    slidesPerView: 6.2,
                },
            },
        });

        $('#settings__reset').on('click', function() {
            const resetPrefs = confirm('This will erase all or your saved preferences. Are you sure?');
            if (resetPrefs === true) {
                eraseCookie('nescol_interests');
                eraseCookie('nescol_postCats');
                eraseCookie('nescol_posts');
                eraseCookie('nescol_courses');
                $('.settings__catergories > .categories').html('');
                pinnedInterestsSwiper.removeAllSlides();
                pinnedPostsSwiper.removeAllSlides();
                pinnedInterestsSwiper.prependSlide(pinnedInterestPlaceholder);
                pinnedPostsSwiper.prependSlide(pinnedPostsPlaceholder);
                $('.unpin').removeClass('unpin');
                loadPrefs();
            } else {
            }
        });

        $('.header-tools .pin-items').on('click', function() {
            toggleSettings();
        });
        $('.settings__close').on('click', function() {
            closeSettings();
        });

        /*
        $('#settings__expand, #settings__compress').on('click',function() {
            $('#settings__expand, #settings__compress').toggleClass('d-none');
            $('.settings__expander').toggleClass('settings__expander--expanded');
        });
        */

        $('#settings-drawer, #main-area').on('click', '.pin-location, .pin-interest', function(e) {
            e.preventDefault();
            const locId = $(this).attr('data-pin-id');
            let locText = $(this).next('a')
                .text();
            console.log(locText);
            const pinHtml = `<span class="pin pin-interest unpin" data-pin-id="${locId}"><span class="fa-stack"><i class="fas fa-circle fa-stack-2x"></i><i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i></span></span>`;
            locText = `<li class="swiper-slide pinned-interests__slide" id="p-loc-slide-${locId}">${pinHtml}<span>${locText}</span></li>`;
            const interestString = locId;
            if (!$(this).hasClass('unpin')) {
                $(this).addClass('unpin');
                pInterests.push(interestString);
                pinnedInterestsSwiper.prependSlide(locText);
            } else {
                pInterests = jQuery.grep(pInterests, function(value) {
                    return value !== interestString;
                });
                const prefToRemove = $(`#p-loc-slide-${interestString}`).index();
                console.log(`slide bin ${interestString} - ${prefToRemove}`);
                pinnedInterestsSwiper.removeSlide(prefToRemove);
                $(`[data-pin-id='${interestString}']`).removeClass('unpin');
                $(this).removeClass('unpin');
            }
            const jsonpInterests = JSON.stringify(pInterests);
            createCookie('nescol_interests', jsonpInterests, 9999);
            loadPrefs();
        });

        //     $('#course-output').on('click', '.pin-course', function(e) {
        $('#course-output').on('click', '.course-index-inner .pin-course', function(e) {
            e.preventDefault();
            const courseId = $(this).attr('data-pin-id');
            const postid = $(this).attr('data-pin-id');
            console.log(courseId);
            const courseCats = [];

            if (!$(this).hasClass('unpin')) {
                $(this).addClass('unpin');
                pCourses.push(courseId);
                $(this)
                    .parent()
                    .parent()
                    .parent()
                    .find('.course-detail li')
                    .each(function() {
                        courseCats.push($(this).attr('data-pin-subjectcat'));
                    });
                const courseDiv = $(this).parent()
                    .parent()
                    .parent();
                courseCats.forEach(function(courseCat) {
                    const interestString = `term_${courseCat}`;
                    if (pInterests.includes(interestString) === false) {
                        if (courseCat) {
                            pInterests.push(interestString);
                            // const postPermalink = $(`#post_detail-${postCat}`).attr('data-tax-link');
                            // const catColour = $(`#post_detail-${postCat}`).attr('data-tax-colour');
                            // const catName = $(`#post_detail-${postCat}`).attr('data-tax-name');
                            // const catLabel = `Open ${catName} Category`;
                            const pinHtml = `<span class="pin pin-subjectcat unpin" data-pin-id="${interestString}"><span class="fa-stack"><i class="fas fa-circle fa-stack-2x"></i><i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i></span></span>`;
                            let catText = courseDiv.find(`[data-pin-subjectcat="${courseCat}"]`).text();
                            catText = `<li class="swiper-slide pinned-interests__slide" id="p-subject-slide-${courseCat}">${pinHtml}<span>${catText}</span></li>`;
                            console.log(catText);
                            pinnedInterestsSwiper.prependSlide(catText);
                        }
                    }
                });
                // Add to drawer...
                if (pPosts.includes(postid) === false) {
                    pPosts.push(postid);
                    const tileQualification = courseDiv.find('.qualification-scqf').html();
                    const tileHeading = courseDiv.find('h2 > a').html();
                    const tileURL = courseDiv.find('h2 > a').attr('href');
                    const tileText = courseDiv.find('p').html();
                    let qualification = `<ul class="categories"><li><span class="qualification">${tileQualification}</span></li></ul>`;
                    if (typeof tileQualification === 'undefined') {
                        qualification = '<ul class="categories"><li></li></ul>';
                    }
                    const pinHtml = `<span class="pin pin-post unpin" data-pin-id='${postid}'><span class="fa-stack"><i class="fas fa-circle fa-stack-2x"></i><i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i></span></span>`;
                    const tileToPin = `<div class='news-item'><div class="image-area"><a href='${tileURL}'>${pinHtml}${qualification}</a></div><div class='content-area'><h3><a href='${tileURL}'>${tileHeading}</a></h3><p>${tileText}</p></div>`;
                    pinnedPostsSwiper.prependSlide(
                        `<article class='swiper-slide pinned-post-slide' id="p-post-slide-${courseId}">${tileToPin}</article>`
                    );
                }
            } else {
                $(this).removeClass('unpin');
                pCourses = jQuery.grep(pCourses, function(value) {
                    return value !== courseId;
                });
            }
            const jsonppCourses = JSON.stringify(pCourses);
            const jsonpInterests = JSON.stringify(pInterests);
            const jsonpPosts = JSON.stringify(pPosts);
            createCookie('nescol_posts', jsonpPosts, 9999);
            createCookie('nescol_courses', jsonppCourses, 9999);
            createCookie('nescol_interests', jsonpInterests, 9999);
            loadPrefs();
        });
        $('#settings-drawer').on('click', '.pin-subjectcat', function(e) {
            e.preventDefault();
            let subjectId = $(this).attr('data-pin-id');
            $(this).removeClass('unpin');
            pInterests = jQuery.grep(pInterests, function(value) {
                return value !== subjectId;
            });
            // Change subjectID in order to remove pref panel.
            if (subjectId.indexOf('_') > 0) {
                subjectId = subjectId.split('_');
                subjectId = subjectId[1];
            }
            const prefToRemove = $(`#p-subject-slide-${subjectId}`).index();
            pinnedInterestsSwiper.removeSlide(prefToRemove);
            // $(`[data-pin-id='${subjectId}']`).removeClass('unpin');
            const jsonppCourses = JSON.stringify(pCourses);
            const jsonpInterests = JSON.stringify(pInterests);
            createCookie('nescol_courses', jsonppCourses, 9999);
            createCookie('nescol_interests', jsonpInterests, 9999);
            loadPrefs();
        });
        $(
            '#settings-drawer, #main-area, .featured-events, .event-archive>main, .featured-area.news-section~.news-col, .more-articles, .custom-news-archive>main>.news-col, .taxonomy-section'
        ).on('click', '.pin', function(e) {
            e.preventDefault();
            $(this).addClass('pin-transition');
            setTimeout(function() {
                $(this).removeClass('pin-transition');
            }, 500);

            if ($(this).hasClass('pin-post')) {
                let postid = $(this).attr('data-post-id');
                console.log(`postid = ${postid} <-`);
                if (typeof postid === 'undefined') {
                    postid = $(this).attr('data-pin-id'); // in case we're removing a course added by JS.
                }
                const postCats = [];
                console.log(postid);
                if (!$(this).hasClass('unpin')) {
                    $(this).addClass('unpin');
                    $(this)
                        .parent()
                        .parent()
                        .parent()
                        .find('.categories li')
                        .each(function() {
                            postCats.push($(this).attr('data-pin-cat'));
                        });

                    postCats.forEach(function(postCat) {
                        if (pPostCats.includes(postCat) === false) {
                            pPostCats.push(postCat);
                            const postPermalink = $(`#post_detail-${postCat}`).attr('data-tax-link');
                            const catColour = $(`#post_detail-${postCat}`).attr('data-tax-colour');
                            const catName = $(`#post_detail-${postCat}`).attr('data-tax-name');
                            const catLabel = `Open ${catName} Category`;
                            const pinHtml =
                                '<span class="pin pin-cat unpin"><span class="fa-stack"><i class="fas fa-circle fa-stack-2x"></i><i class="fal fa-thumbtack fa-stack-1x fa-inverse"></i></span></span>';
                            const catPillHTML = `<li id="p_cat-${postCat}">${pinHtml}<a href='${postPermalink}' style='background-color:${catColour};' aria-label='${catLabel}'>${catName}</a></li>`;
                            console.log(catPillHTML);
                            $('#settings-drawer .settings__catergories .categories').append(catPillHTML);
                        }
                    });
                    if (pPosts.includes(postid) === false) {
                        pPosts.push(postid);
                        // console.log(pPosts);

                        // Add to drawer...
                        let tileToPin = $(this).parent()
                            .parent()
                            .parent()
                            .parent();

                        console.log(tileToPin.attr('class'));
                        if (tileToPin.hasClass('featured-post')) {
                            tileToPin = $(this).parent()
                                .parent()
                                .parent();
                            console.log(tileToPin.html());
                            const tileImg = tileToPin.find('.image-holder img')
                                .attr('src');
                            const tileHeading = tileToPin.find('h3>a')
                                .html();
                            const tileURL = tileToPin.find('h3>a')
                                .attr('href');
                            const tileText = tileToPin.find('.post-info')
                                .html();
                            tileToPin = `<div class='news-item'><a href='${tileURL}'><img class='img-fluid' src='${tileImg}' alt=''/></a><div class='content-area'><h3><a href='${tileURL}'>${tileHeading}</a></h3>${tileText}</div>`;
                        } else {
                            tileToPin = tileToPin.html();
                        }
                        pinnedPostsSwiper.prependSlide(
                            `<article class='swiper-slide pinned-post-slide' id="p-post-slide-${postid}">${tileToPin}</article>`
                        );
                    }
                } else {
                    pPosts = jQuery.grep(pPosts, function(value) {
                        return value !== postid;
                    });
                    pCourses = jQuery.grep(pCourses, function(value) {
                        return value !== postid;
                    });
                    $(this).removeClass('unpin');
                    $(`[data-pin-id*="${postid}"]`).removeClass('unpin');
                    $(`[data-post-id*="${postid}"]`).removeClass('unpin');
                    const prefToRemove = $(`#p-post-slide-${postid}`).index();
                    pinnedPostsSwiper.removeSlide(prefToRemove);
                    // console.log(pPosts);
                }
            }
            // Remove categories from settings drawer...
            if ($(this).hasClass('pin-cat')) {
                e.preventDefault();
                let catid = $(this).parent()
                    .attr('id');
                catid = catid.split('-')[1];
                $(this).parent()
                    .remove();
                console.log(`REMOVE CAT ${catid}`);
                pPostCats = jQuery.grep(pPostCats, function(value) {
                    return value !== catid;
                });
            }

            const jsonpPostCats = JSON.stringify(pPostCats);
            const jsonpPosts = JSON.stringify(pPosts);
            const jsonppCourses = JSON.stringify(pCourses);
            createCookie('nescol_postCats', jsonpPostCats, 9999);
            createCookie('nescol_posts', jsonpPosts, 9999);
            createCookie('nescol_courses', jsonppCourses, 9999);
            loadPrefs();
        });
    }

    // Mobile filters
    $('.filter-by-options-label').on('click', function() {
        // test window width with lg breakpoint..
        if ($(window).width() < 992) {
            $('.custom-filters').toggleClass('custom-filters--open');
            $('html').addClass('nav-active filters-active');
        }
    });
    $('.close-filters--mobile').on('click', function(e) {
        e.preventDefault();
        $('.custom-filters').removeClass('custom-filters--open');
        $('html').removeClass('nav-active filters-active');
    });
    $('.filters__back').on('click', function(e) {
        e.preventDefault();
        $(this).parent()
            .removeClass('select-box__list--open');
    });
    $('.select-box__option').on('click', function() {
        $(this).parent()
            .parent()
            .removeClass('select-box__list--open');
    });

    $('.select-box > .select-box__current .select-box__input-text').on('click', function(e) {
        e.preventDefault();
        $('.select-box__list')
            .not($(this).parent()
                .parent()
                .parent()
                .find('.select-box__list'))
            .removeClass('select-box__list--open');

        $('.select-box__current')
            .not($(this).parent()
                .parent())
            .removeClass('list--open');

        $(this).parent()
            .parent()
            .parent()
            .find('.select-box__list')
            .toggleClass('select-box__list--open');

        $(this).parent()
            .parent()
            .toggleClass('list--open');
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('.select-box > .select-box__current .select-box__input-text').length) {
            $('.select-box__list').removeClass('select-box__list--open');
            $('.select-box__current').removeClass('list--open');
        }
    });

    $('.mobile-nav-menu-open, .close-nav--mobile').on('click', function(e) {
        e.preventDefault();
        $('.nescol-nav').toggleClass('active');
        $('html').toggleClass('nav-active');
    });

    // Add chevrons to main nav
    $('#menu-main-menu >.menu-item-has-children>a').after(
        '<button class="nav-link dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="fa fa-chevron-down"></span></button>'
    );
    // Add mobile nav buttons to sub-menu's.
    $('#menu-main-menu .sub-menu .menu-item-has-children>a').after(
        '<button class="nav-link dropdown-toggle nav-link--mobile" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="fa fa-chevron-down"></span></button>'
    );
    // Add mobile sub-menu headers
    $('#menu-main-menu .sub-menu').each(function() {
        const navHeader = $(this).parent()
            .find('>a:first-child')
            .text();
        $(this).prepend(
            `<li class="sub-menu__header"><button class="nav-link" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="fa fa-chevron-left"></span>${navHeader}</button></li>`
        );
    });

    $('#menu-main-menu .dropdown-toggle').on('click', function(e) {
        e.preventDefault();
        $(this).parent()
            .toggleClass('show')
            .find('>.sub-menu')
            .toggleClass('active');
    });

    $('.sub-menu__header').on('click', function() {
        $(this).parent()
            .removeClass('active');
    });

    $('.interested-in').on('click', function() {
        $('.super-categories').slideToggle();
        $(this).find('svg')
            .toggleClass('rotate');
    });

    $(window).on('load scroll', function() {
        if ($(window).scrollTop() > 100) {
            $('.navigation-image').fadeOut();
            $('.navigation-image-small').fadeIn();
            $('.pin-nav').addClass('active');
            if ($('.site-header').hasClass('headroom--unpinned') && $(window).scrollTop() > 200) {
                closeSettings();
                $('.pinDrawerTip').removeClass('pinDrawerTip');
                $('.header-tools .pin-items').addClass('hide-pintip');
            }
        } else {
            $('.navigation-image').stop()
                .fadeIn();
            $('.navigation-image-small').hide();
            $('.pin-nav').removeClass('active');
        }
    });

    if ($('.hero-swiper .swiper-slide').length > 1) {
        new Swiper('.hero-swiper', {
            loop: true,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
        });
    }

    new Swiper('.info-swiper', {
        loop: true,
        slidesPerView: 4,
        spaceBetween: 25,
        loopAdditionalSlides: 3,
        keyboard: {
            onlyInViewport: true,
            enabled: true,
        },
        navigation: {
            nextEl: '.info-swiper-next',
            prevEl: '.info-swiper-prev',
        },
        breakpoints: {
            768: {
                centeredSlides: true,
                slidesPerView: 1.1,
            },
            1200: {
                slidesPerView: 2,
            },
            1550: {
                slidesPerView: 3,
            },
        },
    });

    new Swiper('.story-swiper', {
        slidesPerView: 3,
        spaceBetween: 50,
        loopAdditionalSlides: 3,
        keyboard: {
            onlyInViewport: true,
            enabled: true,
        },
        navigation: {
            nextEl: '.story-swiper-next',
            prevEl: '.story-swiper-prev',
        },
        breakpoints: {
            768: {
                slidesPerView: 1.1,
                spaceBetween: 25,
            },
            992: {
                slidesPerView: 1.1,
            },
            1550: {
                slidesPerView: 2,
            },
        },
    });
    new Swiper('.news-swiper', {
        slidesPerView: 4,
        spaceBetween: 50,
        keyboard: {
            onlyInViewport: true,
            enabled: true,
        },
        navigation: {
            nextEl: '.news-swiper-next',
            prevEl: '.news-swiper-prev',
        },
        breakpoints: {
            768: {
                spaceBetween: 25,
                slidesPerView: 1.1,
            },
            992: {
                slidesPerView: 2,
            },
            1550: {
                slidesPerView: 3,
            },
        },
    });

    new Swiper('.gallery-swiper', {
        loop: true,
        slidesPerView: 3,
        spaceBetween: 25,
        keyboard: {
            enabled: true,
            onlyInViewport: true,
        },
        navigation: {
            nextEl: '.custom-next-button',
            prevEl: '.custom-prev-button',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            768: {
                slidesPerView: 1,
            },
            992: {
                slidesPerView: 2,
            },
        },
    });

    new Swiper('.post-swiper', {
        loop: true,
        slidesPerView: 3,
        spaceBetween: 25,
        keyboard: {
            enabled: true,
            onlyInViewport: true,
        },
        navigation: {
            nextEl: '.custom-next-button',
            prevEl: '.custom-prev-button',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            768: {
                slidesPerView: 1,
            },
            992: {
                slidesPerView: 2,
            },
        },
    });

    if (readCookie('notification') === 'dismissed') {
        $('.notification-bar').remove();
    }
    $('.notification-bar__close').on('click', function(e) {
        e.preventDefault();
        $('.notification-bar').fadeOut();
        createCookie('notification', 'dismissed', 1);
    });
    $('.watch-video').on('click', function() {
        $('.hero-video').trigger('play');
        $('.hero-video').attr('controls', '');
        $('.swiper-block').fadeOut();
        $('.hero-section .custom-svg').fadeOut();
        $('.hero-section .notification-bar').fadeOut();
        $('.close-video').fadeIn();
        $('.hero-swiper').addClass('video-active');
    });

    $('.close-video').on('click', function() {
        $(this).fadeOut();
        $('.swiper-block').fadeIn();
        $('.hero-section .custom-svg').fadeIn();
        $('.hero-section .notification-bar').fadeIn();
        $('.hero-swiper').removeClass('video-active');
        $('.hero-video').removeAttr('controls');
    });

    // Accessibilty features
    $('.switch-item').on('click', function() {
        const myCookie = $(this).attr('id');
        if ($(this).find('.checkbox')
            .is(':checked')) {
            $(this).find('.switch-state')
                .text('on');
            $('body').addClass(myCookie);
            $(this).addClass('switch-on');
            createCookie(myCookie, 'on', 9999);
        } else {
            $(this).find('.switch-state')
                .text('off');
            $('body').removeClass(myCookie);
            $(this).removeClass('switch-on');
            createCookie(myCookie, 'off', 9999);
        }
    });

    if (readCookie('accessibility--reduced-motion') === 'on') {
        $('body').addClass('accessibility--reduced-motion');
        $('#accessibility--reduced-motion .checkbox').prop('checked', true);
        $('#accessibility--reduced-motion').addClass('switch-on')
            .find('.switch-state')
            .text('on');
    }
    if (readCookie('accessibility--high-contrast') === 'on') {
        $('body').addClass('accessibility--high-contrast');
        $('#accessibility--high-contrast .checkbox').prop('checked', true);
        $('#accessibility--high-contrast').addClass('switch-on')
            .find('.switch-state')
            .text('on');
    }

    //Desktop Menu Functions
    $('.nescol-nav .activate-search').on('click', function(e) {
        e.preventDefault();
        $('.nescol-nav .menu-holder').toggleClass('search-active');
        $('#header-search').focus();
    });
    $('.mobile-nav-holder .activate-search').on('click', function(e) {
        e.preventDefault();
        $('.mobile-nav-holder').addClass('search-active');
        $('.mobile-navigation').css('overflow', 'hidden');
        $('.search-holder__form--mobile').addClass('activated');
        $('#header-search--mob').focus();
    });
    $('.nescol-nav .search-holder__form .remove-search').on('click', function(e) {
        e.preventDefault();
        $('.menu-holder').removeClass('search-active');
        $('#header-search').focusout();
    });
    $('.search-holder__form--mobile .remove-search').on('click', function(e) {
        e.preventDefault();
        $('.mobile-nav-holder').removeClass('search-active');
        $('.search-holder__form--mobile').removeClass('activated');
        setTimeout(function() {
            $('.mobile-navigation').css('overflow', '');
        }, 1000);
        $('#header-search').focusout();
    });

    $(document).on('nfFormReady', function() {
        if ($('#nf-field-261').length) {
            const courseName = new URLSearchParams(window.location.search).get('courseName');
            if (courseName) {
                $('#nf-field-261').val(courseName);
            }
        }
    });

    if (typeof Marionette !== 'undefined' && typeof Backbone !== 'undefined') {
        // eslint-disable-next-line no-undef
        const SubmitController = Marionette.Object.extend({
            initialize() {
                // eslint-disable-next-line no-undef
                this.listenTo(Backbone.Radio.channel('forms'), 'submit:response', this.actionSubmit);
            },
            actionSubmit(response) {
                // Do stuff here.
                let showButton = true;
                if (response.data.actions) {
                    if (response.data.actions.success_message) {
                        console.log(response.data.actions.success_message);
                        if (response.data.actions.success_message.indexOf('noButton') > -1) {
                            showButton = false;
                        }
                    }
                }
                if (response.data.redirect && showButton === true) {
                    const html = `<form action="${response.data.redirect}" method="post" target="_blank"><input type="submit" class="sagepay-btn" value="Proceed to Payment" /></form>`;
                    $('.nf-after-form').append(html);
                }
            },
        });
        new SubmitController();
    }
};
export default common;
