<?php

$galleryItems = get_sub_field('gallery_items');

if($galleryItems) { ?>
    <div class="custom-flexible-section gallery-section">
        <div class="contain">
            <div class="gallery">
                <?php foreach($galleryItems as $item) { ?>
                    <div class="gallery-item">
                        <?php if($item['link']) { ?><a href="<?= $item['link']['url']; ?>"><?php } ?>
                            <div class="image-wrapper">
                                <img src="<?= $item['image']['url']; ?>" loading="lazy">
                            </div>
                            <div class="content-wrapper">
                                <?php if($item['primary_text']) { ?><h3 class="u-case fw-700"><?= $item['primary_text']; ?></h3><?php } ?>
                                <?php if($item['secondary_text']) { ?><h4><?= $item['secondary_text']; ?></h4><?php } ?>
                            </div>
                        <?php if($item['link']) { ?></a><?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
